/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.Map;
import org.keycloak.broker.provider.mappersync.ConfigSynchronizer;
import org.keycloak.models.GroupModel;

public class GroupConfigPropertyByPathSynchronizer
implements ConfigSynchronizer<GroupModel.GroupPathChangeEvent> {
    public static final GroupConfigPropertyByPathSynchronizer INSTANCE = new GroupConfigPropertyByPathSynchronizer();

    private GroupConfigPropertyByPathSynchronizer() {
    }

    @Override
    public Class<GroupModel.GroupPathChangeEvent> getEventClass() {
        return GroupModel.GroupPathChangeEvent.class;
    }

    @Override
    public void handleEvent(GroupModel.GroupPathChangeEvent event) {
        event.getKeycloakSession().identityProviders().getMappersStream(Map.of("group", event.getPreviousPath()), null, null).forEach(idpMapper -> {
            idpMapper.getConfig().put("group", event.getNewPath());
            this.logEventProcessed("group", event.getPreviousPath(), event.getNewPath(), event.getRealm().getName(), idpMapper.getName(), idpMapper.getIdentityProviderAlias());
            event.getKeycloakSession().identityProviders().updateMapper(idpMapper);
        });
        event.getKeycloakSession().identityProviders().getMappersStream(Map.of("group", event.getPreviousPath() + "/*"), null, null).forEach(idpMapper -> {
            String currentGroupPath = (String)idpMapper.getConfig().get("group");
            String newGroupPath = event.getNewPath() + currentGroupPath.substring(event.getPreviousPath().length());
            idpMapper.getConfig().put("group", newGroupPath);
            this.logEventProcessed("group", currentGroupPath, newGroupPath, event.getRealm().getName(), idpMapper.getName(), idpMapper.getIdentityProviderAlias());
            event.getKeycloakSession().identityProviders().updateMapper(idpMapper);
        });
    }
}

