/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowError;

public class AuthenticationFlowException
extends RuntimeException {
    private AuthenticationFlowError error;
    private Response response;
    private List<AuthenticationFlowException> afeList;
    private String eventDetails;
    private String userErrorMessage;

    public AuthenticationFlowException(AuthenticationFlowError error) {
        this.error = error;
    }

    public AuthenticationFlowException(AuthenticationFlowError error, String eventDetails, String userErrorMessage) {
        this.error = error;
        this.eventDetails = eventDetails;
        this.userErrorMessage = userErrorMessage;
    }

    public AuthenticationFlowException(AuthenticationFlowError error, Response response) {
        this.error = error;
        this.response = response;
    }

    public AuthenticationFlowException(String message, AuthenticationFlowError error) {
        super(message);
        this.error = error;
    }

    public AuthenticationFlowException(String message, Throwable cause, AuthenticationFlowError error) {
        super(message, cause);
        this.error = error;
    }

    public AuthenticationFlowException(Throwable cause, AuthenticationFlowError error) {
        super(cause);
        this.error = error;
    }

    public AuthenticationFlowException(List<AuthenticationFlowException> afeList) {
        this.error = AuthenticationFlowError.INTERNAL_ERROR;
        this.afeList = afeList;
    }

    public AuthenticationFlowException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, AuthenticationFlowError error) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.error = error;
    }

    public AuthenticationFlowError getError() {
        return this.error;
    }

    public Response getResponse() {
        return this.response;
    }

    public List<AuthenticationFlowException> getAfeList() {
        return this.afeList;
    }

    public String getEventDetails() {
        return this.eventDetails;
    }

    public String getUserErrorMessage() {
        return this.userErrorMessage;
    }
}

