/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.document.RdfDocument;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentReader;
import com.apicatalog.rdf.Rdf;
import java.io.InputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class DocumentResolver {
    private static final Logger LOGGER = Logger.getLogger(DocumentResolver.class.getName());
    private MediaType fallbackContentType = null;

    public DocumentReader<InputStream> getReader(MediaType contentType) throws JsonLdError {
        return DocumentResolver.findReader(contentType).or(() -> {
            if (this.fallbackContentType != null) {
                LOGGER.log(Level.WARNING, "Content type [{0}] is not acceptable, trying again with [{1}].", new Object[]{contentType, this.fallbackContentType});
                return DocumentResolver.findReader(this.fallbackContentType);
            }
            return Optional.empty();
        }).orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported media type '" + contentType + "'. Supported content types are [" + MediaType.JSON_LD + ", " + MediaType.JSON + ", +json, " + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]"));
    }

    public void setFallbackContentType(MediaType fallbackContentType) {
        this.fallbackContentType = fallbackContentType;
    }

    private static final Optional<DocumentReader<InputStream>> findReader(MediaType type) {
        if (type == null) {
            return Optional.empty();
        }
        if (JsonDocument.accepts(type)) {
            return Optional.of(is -> JsonDocument.of(type, is));
        }
        if (RdfDocument.accepts(type)) {
            return Optional.of(is -> RdfDocument.of(type, is));
        }
        return Optional.empty();
    }
}

