/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteMethodDescription;
import io.smallrye.common.annotation.NonBlocking;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ResourceNotFoundData {
    private static final Logger LOG = Logger.getLogger(ResourceNotFoundData.class);
    private static volatile List<RouteDescription> runtimeRoutes = null;
    private static volatile List<String> servletMappings = new ArrayList<String>();
    private static final String META_INF_RESOURCES = "META-INF/resources";
    private String baseUrl;
    private String httpRoot;
    private List<RouteDescription> endpointRoutes = Collections.emptyList();
    private Set<String> staticRoots = Collections.emptySet();
    private List<AdditionalRouteDescription> additionalEndpoints = Collections.emptyList();
    private static final String HEADING = "404 - Resource Not Found";
    private static final String RESOURCE_ENDPOINTS = "Resource Endpoints";
    private static final String SERVLET_MAPPINGS = "Servlet mappings";
    private static final String STATIC_RESOURCES = "Static resources";
    private static final String ADDITIONAL_ENDPOINTS = "Additional endpoints";
    private static final String URI = "uri";
    private static final String DESCRIPTION = "description";
    private static final String EMPTY = "";
    private static final String NL = "\n";
    private static final String TAB = "\t";

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setHttpRoot(String httpRoot) {
        this.httpRoot = httpRoot;
    }

    public void setEndpointRoutes(List<RouteDescription> endpointRoutes) {
        this.endpointRoutes = endpointRoutes;
    }

    public void setStaticRoots(Set<String> staticRoots) {
        this.staticRoots = staticRoots;
    }

    public void setAdditionalEndpoints(List<AdditionalRouteDescription> additionalEndpoints) {
        this.additionalEndpoints = additionalEndpoints;
    }

    public static void addServlet(String mapping) {
        servletMappings.add(mapping);
    }

    public static void setRuntimeRoutes(List<RouteDescription> routeDescriptions) {
        runtimeRoutes = routeDescriptions;
    }

    public String getHTMLContent() {
        List<String> resources;
        List<RouteDescription> combinedRoutes = this.getCombinedRoutes();
        TemplateHtmlBuilder builder = new TemplateHtmlBuilder(this.baseUrl, HEADING, EMPTY, "Resources overview", List.of());
        builder.resourcesStart(RESOURCE_ENDPOINTS);
        for (RouteDescription routeDescription : combinedRoutes) {
            builder.resourcePath(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)routeDescription.getBasePath()));
            for (RouteMethodDescription method : routeDescription.getCalls()) {
                builder.method(method.getHttpMethod(), TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)method.getFullPath()));
                if (method.getJavaMethod() != null) {
                    builder.listItem(method.getJavaMethod());
                }
                if (method.getConsumes() != null) {
                    builder.consumes(method.getConsumes());
                }
                if (method.getProduces() != null) {
                    builder.produces(method.getProduces());
                }
                builder.methodEnd();
            }
            builder.resourceEnd();
        }
        if (combinedRoutes.isEmpty()) {
            builder.noResourcesFound();
        }
        builder.resourcesEnd();
        if (!servletMappings.isEmpty()) {
            builder.resourcesStart(SERVLET_MAPPINGS);
            for (String string : servletMappings) {
                builder.servletMapping(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)string));
            }
            builder.resourcesEnd();
        }
        if (!this.staticRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
            builder.resourcesStart(STATIC_RESOURCES);
            for (String staticResource : resources) {
                builder.staticResourcePath(TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)staticResource));
            }
            builder.resourcesEnd();
        }
        if (!this.additionalEndpoints.isEmpty()) {
            builder.resourcesStart(ADDITIONAL_ENDPOINTS, "sortable");
            for (AdditionalRouteDescription additionalRouteDescription : this.additionalEndpoints) {
                builder.staticResourcePath(additionalRouteDescription.getUri(), additionalRouteDescription.getDescription());
            }
            builder.resourcesEnd();
        }
        return builder.toString();
    }

    @NonBlocking
    public JsonObject getJsonContent() {
        List<String> resources;
        List<RouteDescription> combinedRoutes = this.getCombinedRoutes();
        JsonObject infoMap = new JsonObject();
        if (!combinedRoutes.isEmpty()) {
            JsonArray r = new JsonArray();
            for (RouteDescription routeDescription : combinedRoutes) {
                String path = TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)routeDescription.getBasePath());
                for (RouteMethodDescription method : routeDescription.getCalls()) {
                    Object description = method.getHttpMethod();
                    if (method.getConsumes() != null) {
                        description = (String)description + " (consumes: " + method.getConsumes() + ")";
                    }
                    if (method.getProduces() != null) {
                        description = (String)description + " (produces:" + method.getProduces() + ")";
                    }
                    if (method.getJavaMethod() != null) {
                        description = (String)description + " (java:" + method.getJavaMethod() + ")";
                    }
                    r.add((Object)JsonObject.of((String)URI, (Object)TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)method.getFullPath()), (String)DESCRIPTION, (Object)description));
                }
            }
            infoMap.put(RESOURCE_ENDPOINTS, (Object)r);
        }
        if (!servletMappings.isEmpty()) {
            JsonArray sm = new JsonArray();
            for (String string : servletMappings) {
                sm.add((Object)JsonObject.of((String)URI, (Object)TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)string), (String)DESCRIPTION, (Object)EMPTY));
            }
            infoMap.put(SERVLET_MAPPINGS, (Object)sm);
        }
        if (!this.staticRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
            JsonArray sr = new JsonArray();
            for (String staticResource : resources) {
                sr.add((Object)JsonObject.of((String)URI, (Object)TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)staticResource), (String)DESCRIPTION, (Object)EMPTY));
            }
            infoMap.put(STATIC_RESOURCES, (Object)sr);
        }
        if (!this.additionalEndpoints.isEmpty()) {
            JsonArray ae = new JsonArray();
            for (AdditionalRouteDescription additionalRouteDescription : this.additionalEndpoints) {
                ae.add((Object)JsonObject.of((String)URI, (Object)additionalRouteDescription.getUri(), (String)DESCRIPTION, (Object)additionalRouteDescription.getDescription()));
            }
            infoMap.put(ADDITIONAL_ENDPOINTS, (Object)ae);
        }
        return infoMap;
    }

    @NonBlocking
    public String getTextContent() {
        Iterator<AdditionalRouteDescription> iterator;
        List<RouteDescription> combinedRoutes = this.getCombinedRoutes();
        StringWriter sw = new StringWriter();
        try {
            List<String> resources;
            sw.write("\n404 - Resource Not Found\n");
            sw.write("------------------------\n");
            sw.write(NL);
            if (!combinedRoutes.isEmpty()) {
                sw.write("Resource Endpoints\n");
                for (RouteDescription routeDescription : combinedRoutes) {
                    for (RouteMethodDescription method : routeDescription.getCalls()) {
                        Object description = method.getHttpMethod();
                        if (method.getConsumes() != null) {
                            description = (String)description + " (consumes: " + method.getConsumes() + ")";
                        }
                        if (method.getProduces() != null) {
                            description = (String)description + " (produces:" + method.getProduces() + ")";
                        }
                        if (method.getJavaMethod() != null) {
                            description = (String)description + " (java:" + method.getJavaMethod() + ")";
                        }
                        sw.write("\t- " + TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)method.getFullPath()) + NL);
                        sw.write("\t\t- " + (String)description + NL);
                    }
                }
                sw.write(NL);
            }
            if (!servletMappings.isEmpty()) {
                sw.write("Servlet mappings\n");
                for (String string : servletMappings) {
                    sw.write("\t- " + TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)string) + NL);
                }
                sw.write(NL);
            }
            if (!this.staticRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
                sw.write("Static resources\n");
                for (String staticResource : resources) {
                    sw.write("\t- " + TemplateHtmlBuilder.adjustRoot((String)this.httpRoot, (String)staticResource) + NL);
                }
                sw.write(NL);
            }
            if (!this.additionalEndpoints.isEmpty()) {
                sw.write("Additional endpoints\n");
                for (AdditionalRouteDescription additionalRouteDescription : this.additionalEndpoints) {
                    sw.write("\t- " + additionalRouteDescription.getUri() + NL);
                    sw.write("\t\t- " + additionalRouteDescription.getDescription() + NL);
                }
                sw.write(NL);
            }
            iterator = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        sw.close();
        return iterator;
    }

    private List<RouteDescription> getCombinedRoutes() {
        ArrayList<RouteDescription> combinedRoutes = new ArrayList<RouteDescription>();
        if (runtimeRoutes != null) {
            combinedRoutes.addAll(runtimeRoutes);
        }
        if (this.endpointRoutes != null) {
            combinedRoutes.addAll(this.endpointRoutes);
        }
        return combinedRoutes;
    }

    private List<String> findRealResources() {
        final HashSet knownFiles = new HashSet();
        for (String staticResourceRoot : this.staticRoots) {
            Path resource;
            if (staticResourceRoot == null || !Files.exists(resource = Paths.get(staticResourceRoot, new String[0]), new LinkOption[0])) continue;
            try {
                Stream<Path> fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
                try {
                    fileTreeElements.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path path) {
                            if (resource.equals(path)) {
                                return;
                            }
                            Path rel = resource.relativize(path);
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                knownFiles.add("/" + rel.toString());
                            }
                        }
                    });
                }
                finally {
                    if (fileTreeElements == null) continue;
                    fileTreeElements.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read static resources", (Throwable)e);
            }
        }
        try {
            ClassPathUtils.consumeAsPaths((String)META_INF_RESOURCES, p -> this.collectKnownPaths((Path)p, knownFiles));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read static resources", (Throwable)e);
        }
        return knownFiles.stream().filter(this::isHtmlFileName).limit(1000L).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String file = resource.relativize(p).toString();
                    if (!(file = file.replace('\\', '/')).startsWith("_static/") && !file.startsWith("webjars/")) {
                        knownPaths.add("/" + file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm") || fileName.endsWith(".xhtml");
    }
}

