/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class UniCreateFromCompletionStage<T>
extends AbstractUni<T> {
    private final Supplier<? extends CompletionStage<? extends T>> supplier;

    public UniCreateFromCompletionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        CompletionStage<? extends T> stage;
        try {
            stage = this.supplier.get();
        }
        catch (Throwable e) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, e);
            return;
        }
        if (stage == null) {
            EmptyUniSubscription.propagateFailureEvent(subscriber, new NullPointerException("The produced CompletionStage is `null`"));
            return;
        }
        new CompletionStageUniSubscription<T>(subscriber, stage).forward();
    }

    static class CompletionStageUniSubscription<T>
    implements UniSubscription {
        private final UniSubscriber<? super T> subscriber;
        private final CompletionStage<? extends T> stage;
        private volatile boolean cancelled = false;

        CompletionStageUniSubscription(UniSubscriber<? super T> subscriber, CompletionStage<? extends T> stage) {
            this.subscriber = subscriber;
            this.stage = stage;
        }

        public void forward() {
            this.subscriber.onSubscribe(this);
            this.stage.whenComplete(this::forwardResult);
        }

        private void forwardResult(T res, Throwable fail) {
            if (!this.cancelled) {
                if (fail != null) {
                    if (fail instanceof CompletionException) {
                        this.subscriber.onFailure(fail.getCause());
                    } else {
                        this.subscriber.onFailure(fail);
                    }
                } else {
                    this.subscriber.onItem(res);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.stage.toCompletableFuture().cancel(false);
        }
    }
}

