/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class UniOnNull<T> {
    private final Uni<T> upstream;

    public UniOnNull(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }

    @CheckReturnValue
    public Uni<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(this.upstream.onItem().transformToUni((item, emitter) -> {
            Throwable throwable;
            if (item != null) {
                emitter.complete(item);
                return;
            }
            try {
                throwable = (Throwable)actual.get();
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (throwable == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
            } else {
                emitter.fail(throwable);
            }
        }));
    }

    @CheckReturnValue
    public Uni<T> fail() {
        return this.failWith(NoSuchElementException::new);
    }

    @CheckReturnValue
    public Uni<T> switchTo(Uni<? extends T> other) {
        return this.switchTo(() -> other);
    }

    @CheckReturnValue
    public Uni<T> switchTo(Supplier<Uni<? extends T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        Uni uni = this.upstream.onItem().transformToUni(res -> {
            Uni produced;
            if (res != null) {
                return Uni.createFrom().item(res);
            }
            try {
                produced = (Uni)actual.get();
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
            if (produced == null) {
                return Uni.createFrom().failure(new NullPointerException("The supplier returned `null`"));
            }
            return produced;
        });
        return Infrastructure.onUniCreation(uni);
    }

    @CheckReturnValue
    public Uni<T> continueWith(T fallback) {
        ParameterValidation.nonNull(fallback, "fallback");
        return this.continueWith(() -> fallback);
    }

    @CheckReturnValue
    public Uni<T> continueWith(Supplier<? extends T> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onUniCreation(this.upstream.onItem().transform(res -> {
            if (res != null) {
                return res;
            }
            Object outcome = actual.get();
            if (outcome == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            return outcome;
        }));
    }
}

