/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.FieldInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodPredicates;
import io.quarkus.arc.processor.bcextensions.PackageInfoImpl;
import io.quarkus.arc.processor.bcextensions.RecordComponentInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.PackageInfo;
import jakarta.enterprise.lang.model.types.TypeVariable;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;

class ClassInfoImpl
extends DeclarationInfoImpl<org.jboss.jandex.ClassInfo>
implements ClassInfo {
    ClassInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, org.jboss.jandex.ClassInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlay, jandexDeclaration);
    }

    public String name() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).name().toString();
    }

    public String simpleName() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).simpleName();
    }

    public PackageInfo packageInfo() {
        String packageName = ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).name().packagePrefix();
        org.jboss.jandex.ClassInfo packageClass = this.jandexIndex.getClassByName(DotName.createSimple((String)(packageName + ".package-info")));
        return new PackageInfoImpl(this.jandexIndex, this.annotationOverlay, packageClass);
    }

    public List<TypeVariable> typeParameters() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).typeParameters().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, (Type)it)).filter(jakarta.enterprise.lang.model.types.Type::isTypeVariable).map(jakarta.enterprise.lang.model.types.Type::asTypeVariable).toList();
    }

    public jakarta.enterprise.lang.model.types.Type superClass() {
        Type jandexSuperType = ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).superClassType();
        if (jandexSuperType == null) {
            return null;
        }
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, jandexSuperType);
    }

    public ClassInfo superClassDeclaration() {
        DotName jandexSuperType = ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).superName();
        if (jandexSuperType == null) {
            return null;
        }
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlay, this.jandexIndex.getClassByName(jandexSuperType));
    }

    public List<jakarta.enterprise.lang.model.types.Type> superInterfaces() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).interfaceTypes().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, it)).toList();
    }

    public List<ClassInfo> superInterfacesDeclarations() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).interfaceNames().stream().map(it -> new ClassInfoImpl(this.jandexIndex, this.annotationOverlay, this.jandexIndex.getClassByName(it))).toList();
    }

    public boolean isPlainClass() {
        return !this.isInterface() && !this.isEnum() && !this.isAnnotation() && !this.isRecord();
    }

    public boolean isInterface() {
        if (this.isAnnotation()) {
            return false;
        }
        return Modifier.isInterface(((org.jboss.jandex.ClassInfo)this.jandexDeclaration).flags());
    }

    public boolean isEnum() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).isEnum();
    }

    public boolean isAnnotation() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).isAnnotation();
    }

    public boolean isRecord() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).isRecord();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((org.jboss.jandex.ClassInfo)this.jandexDeclaration).flags());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((org.jboss.jandex.ClassInfo)this.jandexDeclaration).flags());
    }

    public int modifiers() {
        return ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).flags();
    }

    public Collection<MethodInfo> constructors() {
        ArrayList<MethodInfoImpl> result = new ArrayList<MethodInfoImpl>();
        for (org.jboss.jandex.MethodInfo jandexMethod : ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).methods()) {
            if (jandexMethod.isSynthetic() || !MethodPredicates.IS_CONSTRUCTOR_JANDEX.test(jandexMethod)) continue;
            result.add(new MethodInfoImpl(this.jandexIndex, this.annotationOverlay, jandexMethod));
        }
        return Collections.unmodifiableList(result);
    }

    private List<org.jboss.jandex.ClassInfo> allSupertypes() {
        ArrayList<org.jboss.jandex.ClassInfo> result = new ArrayList<org.jboss.jandex.ClassInfo>();
        HashSet<DotName> alreadySeen = new HashSet<DotName>();
        ArrayDeque<org.jboss.jandex.ClassInfo> workQueue = new ArrayDeque<org.jboss.jandex.ClassInfo>();
        workQueue.add((org.jboss.jandex.ClassInfo)this.jandexDeclaration);
        while (!workQueue.isEmpty()) {
            org.jboss.jandex.ClassInfo clazz = (org.jboss.jandex.ClassInfo)workQueue.remove();
            if (alreadySeen.contains(clazz.name())) continue;
            result.add(clazz);
            alreadySeen.add(clazz.name());
            DotName superClassName = clazz.superName();
            if (superClassName != null && !DotNames.OBJECT.equals((Object)superClassName)) {
                org.jboss.jandex.ClassInfo superClass = this.jandexIndex.getClassByName(superClassName);
                workQueue.add(superClass);
            }
            for (DotName superInterfaceName : clazz.interfaceNames()) {
                org.jboss.jandex.ClassInfo superInterface = this.jandexIndex.getClassByName(superInterfaceName);
                workQueue.add(superInterface);
            }
        }
        return result;
    }

    public Collection<MethodInfo> methods() {
        ArrayList<MethodInfoImpl> result = new ArrayList<MethodInfoImpl>();
        for (org.jboss.jandex.ClassInfo clazz : this.allSupertypes()) {
            for (org.jboss.jandex.MethodInfo jandexMethod : clazz.methods()) {
                if (jandexMethod.isSynthetic() || !MethodPredicates.IS_METHOD_JANDEX.test(jandexMethod)) continue;
                result.add(new MethodInfoImpl(this.jandexIndex, this.annotationOverlay, jandexMethod));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<FieldInfo> fields() {
        ArrayList<FieldInfoImpl> result = new ArrayList<FieldInfoImpl>();
        for (org.jboss.jandex.ClassInfo clazz : this.allSupertypes()) {
            for (org.jboss.jandex.FieldInfo jandexField : clazz.fields()) {
                if (jandexField.isSynthetic()) continue;
                result.add(new FieldInfoImpl(this.jandexIndex, this.annotationOverlay, jandexField));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<jakarta.enterprise.lang.model.declarations.RecordComponentInfo> recordComponents() {
        ArrayList<RecordComponentInfoImpl> result = new ArrayList<RecordComponentInfoImpl>();
        for (RecordComponentInfo recordComponent : ((org.jboss.jandex.ClassInfo)this.jandexDeclaration).recordComponents()) {
            result.add(new RecordComponentInfoImpl(this.jandexIndex, this.annotationOverlay, recordComponent));
        }
        return Collections.unmodifiableList(result);
    }
}

