/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.dev;

import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevInfoCreateDDLSupplier;
import io.quarkus.hibernate.orm.runtime.dev.HibernateOrmDevJsonRpcService;
import java.util.List;
import java.util.function.Supplier;

@BuildSteps(onlyIf={HibernateOrmEnabled.class, IsDevelopment.class})
public class HibernateOrmDevUIProcessor {
    @BuildStep
    public CardPageBuildItem create() {
        CardPageBuildItem card = new CardPageBuildItem();
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Persistence Units")).componentLink("hibernate-orm-persistence-units.js").icon("font-awesome-solid:boxes-stacked")).dynamicLabelJsonRPCMethodName("getNumberOfPersistenceUnits"));
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Entity Types")).componentLink("hibernate-orm-entity-types.js").icon("font-awesome-solid:table")).dynamicLabelJsonRPCMethodName("getNumberOfEntityTypes"));
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Named Queries")).componentLink("hibernate-orm-named-queries.js").icon("font-awesome-solid:circle-question")).dynamicLabelJsonRPCMethodName("getNumberOfNamedQueries"));
        return card;
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(HibernateOrmDevJsonRpcService.class);
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().addBeanClass(HibernateOrmDevJsonRpcService.class).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build();
    }

    @BuildStep
    void handleInitialSql(List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<JdbcInitialSQLGeneratorBuildItem> initialSQLGeneratorBuildItemBuildProducer) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            String dsName = puDescriptor.getConfig().getDataSource().orElse("<default>");
            initialSQLGeneratorBuildItemBuildProducer.produce((BuildItem)new JdbcInitialSQLGeneratorBuildItem(dsName, (Supplier)new HibernateOrmDevInfoCreateDDLSupplier(puName)));
        }
    }
}

