/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.grpc.common.GrpcStatus;

@VertxGen
public enum GrpcError {
    INTERNAL(GrpcStatus.INTERNAL, 2L),
    UNAVAILABLE(GrpcStatus.UNAVAILABLE, 7L),
    CANCELLED(GrpcStatus.CANCELLED, 8L),
    RESOURCE_EXHAUSTED(GrpcStatus.RESOURCE_EXHAUSTED, 11L),
    PERMISSION_DENIED(GrpcStatus.PERMISSION_DENIED, 12L);

    public final GrpcStatus status;
    public final long http2ResetCode;

    private GrpcError(GrpcStatus status, long http2ResetCode) {
        this.status = status;
        this.http2ResetCode = http2ResetCode;
    }

    public static GrpcError mapHttp2ErrorCode(long code) {
        switch ((int)code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                return INTERNAL;
            }
            case 7: {
                return UNAVAILABLE;
            }
            case 8: 
            case 10: {
                return CANCELLED;
            }
            case 11: {
                return RESOURCE_EXHAUSTED;
            }
            case 12: {
                return PERMISSION_DENIED;
            }
        }
        return null;
    }
}

