/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query;

import java.nio.charset.StandardCharsets;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EscapeStrategy {
    DEFAULT{

        @Override
        public String escape(String input) {
            StringBuilder output = new StringBuilder();
            block7: for (byte b : input.getBytes(StandardCharsets.UTF_8)) {
                switch (b) {
                    case 92: {
                        output.append("\\5c");
                        continue block7;
                    }
                    case 42: {
                        output.append("\\2a");
                        continue block7;
                    }
                    case 40: {
                        output.append("\\28");
                        continue block7;
                    }
                    case 41: {
                        output.append("\\29");
                        continue block7;
                    }
                    case 0: {
                        output.append("\\00");
                        continue block7;
                    }
                    default: {
                        this.appendByte(b, output);
                    }
                }
            }
            return output.toString();
        }
    }
    ,
    OCTET_STRING{

        @Override
        public String escape(String input) {
            byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
            return 2.escapeHex(bytes);
        }
    };


    public static String escapeHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("\\%02x", b));
        }
        return sb.toString();
    }

    public abstract String escape(String var1);

    protected void appendByte(byte b, StringBuilder output) {
        if (b >= 0) {
            output.append((char)b);
        } else {
            int i = 0xFFFFFF00 ^ b;
            output.append("\\").append(Integer.toHexString(i));
        }
    }
}

