/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class CustomScopeAnnotationsBuildItem
extends SimpleBuildItem {
    private final Set<DotName> customScopeNames;

    CustomScopeAnnotationsBuildItem(Set<DotName> customScopeNames) {
        this.customScopeNames = customScopeNames;
    }

    public Collection<DotName> getCustomScopeNames() {
        return this.customScopeNames;
    }

    public boolean isCustomScopeDeclaredOn(ClassInfo clazz) {
        for (DotName scope : this.customScopeNames) {
            if (clazz.declaredAnnotation(scope) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomScopeIn(Collection<AnnotationInstance> annotations) {
        for (AnnotationInstance annotationInstance : annotations) {
            if (!this.customScopeNames.contains(annotationInstance.name())) continue;
            return true;
        }
        return false;
    }

    public boolean isScopeDeclaredOn(ClassInfo clazz) {
        return BuiltinScope.isDeclaredOn((ClassInfo)clazz) || this.isCustomScopeDeclaredOn(clazz);
    }

    public boolean isScopeIn(Collection<AnnotationInstance> annotations) {
        return !annotations.isEmpty() && (BuiltinScope.isIn(annotations) || this.isCustomScopeIn(annotations));
    }

    public Optional<AnnotationInstance> getScope(Collection<AnnotationInstance> annotations) {
        if (annotations.isEmpty()) {
            return Optional.empty();
        }
        for (AnnotationInstance annotationInstance : annotations) {
            if (BuiltinScope.from((DotName)annotationInstance.name()) == null && !this.customScopeNames.contains(annotationInstance.name())) continue;
            return Optional.of(annotationInstance);
        }
        return Optional.empty();
    }
}

