/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsMap;

public final class ImmutableAttributeMappingsMap
implements AttributeMappingsMap {
    private final HashMap<String, Integer> mapStore;
    private final AttributeMapping[] orderedValues;

    public ImmutableAttributeMappingsMap(LinkedHashMap<String, AttributeMapping> sortedSource) {
        int size = sortedSource.size();
        this.orderedValues = new AttributeMapping[size];
        this.mapStore = new HashMap(size);
        int idx = 0;
        for (Map.Entry<String, AttributeMapping> entry : sortedSource.entrySet()) {
            this.orderedValues[idx] = entry.getValue();
            this.mapStore.put(entry.getKey(), idx);
            ++idx;
        }
    }

    @Override
    public void forEachValue(Consumer<? super AttributeMapping> action) {
        for (AttributeMapping o : this.orderedValues) {
            action.accept(o);
        }
    }

    @Override
    public int size() {
        return this.orderedValues.length;
    }

    @Override
    public AttributeMapping get(String name) {
        Integer o = this.mapStore.get(name);
        if (o == null) {
            return null;
        }
        Integer integer = o;
        return this.orderedValues[integer];
    }

    @Override
    public Iterable<AttributeMapping> valueIterator() {
        return new AttributeMappingIterable();
    }

    private final class AttributeMappingIterator
    implements Iterator<AttributeMapping> {
        private int idx = 0;

        private AttributeMappingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ImmutableAttributeMappingsMap.this.orderedValues.length;
        }

        @Override
        public AttributeMapping next() {
            return ImmutableAttributeMappingsMap.this.orderedValues[this.idx++];
        }
    }

    private final class AttributeMappingIterable
    implements Iterable<AttributeMapping> {
        private AttributeMappingIterable() {
        }

        @Override
        public Iterator<AttributeMapping> iterator() {
            return new AttributeMappingIterator();
        }
    }
}

