/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance;

import java.util.Locale;
import net.bytebuddy.description.type.TypeDescription;
import org.hibernate.bytecode.enhance.spi.EnhancementException;

public class VersionMismatchException
extends EnhancementException {
    private final String typeName;
    private final String enhancementVersion;
    private final String runtimeVersion;

    public VersionMismatchException(TypeDescription typeDescription, String enhancementVersion, String runtimeVersion) {
        super(String.format(Locale.ROOT, "Mismatch between Hibernate version used for bytecode enhancement (%s) and runtime (%s) for `%s`", enhancementVersion, runtimeVersion, typeDescription.getName()));
        this.typeName = typeDescription.getName();
        this.enhancementVersion = enhancementVersion;
        this.runtimeVersion = runtimeVersion;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getEnhancementVersion() {
        return this.enhancementVersion;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }
}

