/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xeustechnologies.jcl.Configuration;
import org.xeustechnologies.jcl.JarClassLoader;
import org.xeustechnologies.jcl.JclUtils;
import org.xeustechnologies.jcl.exception.JclException;

public class JclObjectFactory {
    private static JclObjectFactory jclObjectFactory = new JclObjectFactory();
    private static boolean autoProxy;
    private final transient Logger logger = LoggerFactory.getLogger(JclObjectFactory.class);

    private JclObjectFactory() {
        autoProxy = Configuration.autoProxy();
    }

    public static JclObjectFactory getInstance() {
        return jclObjectFactory;
    }

    public static JclObjectFactory getInstance(boolean autoProxy) {
        JclObjectFactory.autoProxy = autoProxy;
        return jclObjectFactory;
    }

    public Object create(JarClassLoader jcl, String className) {
        return this.create(jcl, className, (Object[])null);
    }

    public Object create(JarClassLoader jcl, String className, Object ... args2) {
        if (args2 == null || args2.length == 0) {
            try {
                return this.newInstance(jcl.loadClass(className).newInstance());
            }
            catch (Throwable e) {
                throw new JclException(e);
            }
        }
        Class[] types = new Class[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            types[i] = args2[i].getClass();
        }
        return this.create(jcl, className, args2, types);
    }

    public Object create(JarClassLoader jcl, String className, Object[] args2, Class[] types) {
        Object obj = null;
        if (args2 == null || args2.length == 0) {
            try {
                obj = jcl.loadClass(className).newInstance();
            }
            catch (Throwable e) {
                throw new JclException(e);
            }
        }
        try {
            obj = jcl.loadClass(className).getConstructor(types).newInstance(args2);
        }
        catch (Exception e) {
            throw new JclException(e);
        }
        return this.newInstance(obj);
    }

    public Object create(JarClassLoader jcl, String className, String methodName, Object ... args2) {
        if (args2 == null || args2.length == 0) {
            try {
                return this.newInstance(jcl.loadClass(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new JclException(e);
            }
        }
        Class[] types = new Class[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            types[i] = args2[i].getClass();
        }
        return this.create(jcl, className, methodName, args2, types);
    }

    public Object create(JarClassLoader jcl, String className, String methodName, Object[] args2, Class[] types) {
        Object obj = null;
        if (args2 == null || args2.length == 0) {
            try {
                obj = jcl.loadClass(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new JclException(e);
            }
        }
        try {
            obj = jcl.loadClass(className).getMethod(methodName, types).invoke(null, args2);
        }
        catch (Exception e) {
            throw new JclException(e);
        }
        return this.newInstance(obj);
    }

    private Object newInstance(Object object) {
        if (autoProxy) {
            Class<?> superClass = null;
            try {
                Class.forName(object.getClass().getSuperclass().getName());
                superClass = object.getClass().getSuperclass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Class<?>[] interfaces = object.getClass().getInterfaces();
            ArrayList il = new ArrayList();
            for (Class<?> i : interfaces) {
                try {
                    Class.forName(i.getClass().getName());
                    il.add(i);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.logger.debug("Class: {}", (Object)superClass);
            this.logger.debug("Class Interfaces: {}", (Object)il);
            if (superClass == null && il.size() == 0) {
                throw new JclException("Neither the class [" + object.getClass().getSuperclass().getName() + "] nor all the implemented interfaces found in the current classloader");
            }
            return JclUtils.createProxy(object, superClass, il.toArray(new Class[il.size()]), null);
        }
        return object;
    }
}

