/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class XHTMLExtension
implements ExtensionElement {
    public static final String ELEMENT = "html";
    public static final String NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    public static final QName QNAME = new QName("http://jabber.org/protocol/xhtml-im", "html");
    private final List<CharSequence> bodies = new ArrayList<CharSequence>();

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.rightAngleBracket();
        for (CharSequence body : this.getBodies()) {
            xml.append(body);
        }
        xml.closeElement(this);
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CharSequence> getBodies() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.bodies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBody(CharSequence body) {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            this.bodies.add(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBodiesCount() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return this.bodies.size();
        }
    }

    public static XHTMLExtension from(MessageView message) {
        return message.getExtension(XHTMLExtension.class);
    }
}

