/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

public class JibriIqProvider
extends SafeParseIqProvider<JibriIq> {
    @Override
    protected JibriIq doParse(XmlPullParser parser, int initialDepth, IqData data2, XmlEnvironment xmlEnvironment) throws Exception {
        JibriIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/jibri".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("jibri".equals(rootElement)) {
            String sipAddress;
            String displayName;
            String shouldRetryStr;
            String failureStr;
            String appData;
            String sessionId;
            String youTubeBroadcastId;
            String streamId;
            String room;
            iq = new JibriIq();
            String action = parser.getAttributeValue("", "action");
            iq.setAction(JibriIq.Action.parse(action));
            String status = parser.getAttributeValue("", "status");
            iq.setStatus(JibriIq.Status.parse(status));
            String recordingMode = parser.getAttributeValue("", "recording_mode");
            if (StringUtils.isNotEmpty(recordingMode)) {
                iq.setRecordingMode(JibriIq.RecordingMode.parse(recordingMode));
            }
            if (StringUtils.isNotEmpty(room = parser.getAttributeValue("", "room"))) {
                EntityBareJid roomJid = JidCreate.entityBareFrom(room);
                iq.setRoom(roomJid);
            }
            if (StringUtils.isNotEmpty(streamId = parser.getAttributeValue("", "streamid"))) {
                iq.setStreamId(streamId);
            }
            if (StringUtils.isNotEmpty(youTubeBroadcastId = parser.getAttributeValue("", "you_tube_broadcast_id"))) {
                iq.setYouTubeBroadcastId(youTubeBroadcastId);
            }
            if (StringUtils.isNotEmpty(sessionId = parser.getAttributeValue("", "session_id"))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty(appData = parser.getAttributeValue("", "app_data"))) {
                iq.setAppData(appData);
            }
            if (StringUtils.isNotEmpty(failureStr = parser.getAttributeValue("", "failure_reason"))) {
                iq.setFailureReason(JibriIq.FailureReason.parse(failureStr));
            }
            if (StringUtils.isNotEmpty(shouldRetryStr = parser.getAttributeValue("", "should_retry"))) {
                iq.setShouldRetry(Boolean.valueOf(shouldRetryStr));
            }
            if (StringUtils.isNotEmpty(displayName = parser.getAttributeValue("", "displayname"))) {
                iq.setDisplayName(displayName);
            }
            if (StringUtils.isNotEmpty(sipAddress = parser.getAttributeValue("", "sipaddress"))) {
                iq.setSipAddress(sipAddress);
            }
        } else {
            return null;
        }
        ParserUtils.forwardToEndTagOfDepth(parser, initialDepth);
        return iq;
    }
}

