/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\bJ\u0012\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/utils/time/FakeClock;", "Ljava/time/Clock;", "debug", "", "zone_", "Ljava/time/ZoneId;", "(ZLjava/time/ZoneId;)V", "now", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "elapse", "", "duration", "Ljava/time/Duration;", "getZone", "instant", "log", "str", "", "setTime", "withZone", "zone", "jitsi-utils"})
public final class FakeClock
extends Clock {
    private final boolean debug;
    @NotNull
    private final ZoneId zone_;
    private Instant now;

    public FakeClock(boolean debug, @NotNull ZoneId zone_) {
        Intrinsics.checkNotNullParameter(zone_, "zone_");
        this.debug = debug;
        this.zone_ = zone_;
        this.now = Instant.ofEpochMilli(0L);
    }

    public /* synthetic */ FakeClock(boolean bl, ZoneId zoneId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId2, "systemDefault(...)");
            zoneId = zoneId2;
        }
        this(bl, zoneId);
    }

    private final void log(String str) {
        if (this.debug) {
            System.out.println((Object)str);
        }
    }

    @Override
    @NotNull
    public Instant instant() {
        Instant instant = this.now;
        Intrinsics.checkNotNullExpressionValue(instant, "now");
        return instant;
    }

    public final void elapse(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "duration");
        this.log("elapsing " + duration);
        this.now = this.now.plus(duration);
    }

    public final void setTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "instant");
        this.log("clock setting time to " + instant);
        this.now = instant;
    }

    @Override
    @NotNull
    public ZoneId getZone() {
        return this.zone_;
    }

    @Override
    @NotNull
    public Clock withZone(@Nullable ZoneId zone) {
        if (Intrinsics.areEqual(this.zone_, zone)) {
            return this;
        }
        ZoneId zoneId = zone;
        Intrinsics.checkNotNull(zoneId);
        return new FakeClock(false, zoneId, 1, null);
    }

    public FakeClock() {
        this(false, null, 3, null);
    }
}

