/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.BaseJibri;
import org.jitsi.jicofo.jibri.JibriConfig;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.util.ErrorResponse;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jibri.SipCallState;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014H\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\"\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0006\u0010\"\u001a\u00020\u001aR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jitsi/jicofo/jibri/JibriSipGateway;", "Lorg/jitsi/jicofo/jibri/BaseJibri;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/jicofo/jibri/JibriDetector;Lorg/jitsi/utils/logging2/Logger;)V", "jibriSessions", "", "Lorg/jitsi/jicofo/jibri/JibriSession;", "getJibriSessions", "()Ljava/util/List;", "sipSessions", "", "", "acceptType", "", "packet", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "getJibriSessionForMeetIq", "iq", "handleStartRequest", "Lorg/jivesoftware/smack/packet/IQ;", "onSessionStateChanged", "", "jibriSession", "newStatus", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$Status;", "failureReason", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq$FailureReason;", "publishJibriSipCallState", "session", "shutdown", "jicofo"})
@SourceDebugExtension(value={"SMAP\nJibriSipGateway.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JibriSipGateway.kt\norg/jitsi/jicofo/jibri/JibriSipGateway\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n*S KotlinDebug\n*F\n+ 1 JibriSipGateway.kt\norg/jitsi/jicofo/jibri/JibriSipGateway\n*L\n65#1:151,2\n*E\n"})
public final class JibriSipGateway
extends BaseJibri {
    @NotNull
    private final Map<String, JibriSession> sipSessions;

    public JibriSipGateway(@NotNull JitsiMeetConferenceImpl conference, @NotNull JibriDetector jibriDetector, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(jibriDetector, "jibriDetector");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(conference, parentLogger, jibriDetector);
        this.sipSessions = new HashMap();
    }

    @Override
    protected boolean acceptType(@NotNull JibriIq packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return StringUtils.isNotBlank(packet.getSipAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        try {
            Iterable $this$forEach$iv = this.sipSessions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JibriSession it = (JibriSession)element$iv;
                boolean bl = false;
                it.stop(null);
            }
        }
        finally {
            this.sipSessions.clear();
        }
    }

    @Override
    @Nullable
    protected JibriSession getJibriSessionForMeetIq(@NotNull JibriIq iq) {
        Intrinsics.checkNotNullParameter(iq, "iq");
        return this.sipSessions.get(iq.getSipAddress());
    }

    @Override
    @NotNull
    public List<JibriSession> getJibriSessions() {
        return new ArrayList<JibriSession>(this.sipSessions.values());
    }

    @Override
    @NotNull
    protected IQ handleStartRequest(@NotNull JibriIq iq) {
        Object object;
        Intrinsics.checkNotNullParameter(iq, "iq");
        if (StringUtils.isNotBlank(iq.getSipAddress())) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String sessionId = string;
            JibriSession jibriSession = new JibriSession(this, this.getConference().getRoomName(), iq.getFrom(), JibriConfig.config.getPendingTimeout().getSeconds(), JibriConfig.config.getNumRetries(), this.getJibriDetector(), false, iq.getSipAddress(), iq.getDisplayName(), null, null, sessionId, null, this.getLogger());
            Object object2 = this.sipSessions;
            String string2 = iq.getSipAddress();
            Intrinsics.checkNotNullExpressionValue(string2, "getSipAddress(...)");
            object2.put((String)string2, (JibriSession)jibriSession);
            try {
                jibriSession.start();
                this.getLogger().info("Started Jibri session");
                object2 = JibriIq.createResult(iq, sessionId);
            }
            catch (JibriSession.StartException exc) {
                String reason = exc.getMessage();
                this.getLogger().warn("Failed to start a Jibri session: " + reason, exc);
                this.sipSessions.remove(iq.getSipAddress());
                JibriSession.StartException startException = exc;
                object2 = startException instanceof JibriSession.StartException.AllBusy ? ErrorResponse.create(iq, StanzaError.Condition.resource_constraint, "all Jibris are busy") : (startException instanceof JibriSession.StartException.NotAvailable ? ErrorResponse.create(iq, StanzaError.Condition.service_unavailable, "no Jibris available") : ErrorResponse.create(iq, StanzaError.Condition.internal_server_error, reason));
            }
            Object object3 = object2;
            Intrinsics.checkNotNull(object3);
            object = object3;
        } else {
            ErrorIQ errorIQ = ErrorResponse.create(iq, StanzaError.Condition.bad_request, "Stream ID is empty or undefined");
            Intrinsics.checkNotNull(errorIQ);
            object = errorIQ;
        }
        return object;
    }

    @Override
    public void onSessionStateChanged(@NotNull JibriSession jibriSession, @NotNull JibriIq.Status newStatus, @Nullable JibriIq.FailureReason failureReason) {
        Intrinsics.checkNotNullParameter(jibriSession, "jibriSession");
        Intrinsics.checkNotNullParameter((Object)newStatus, "newStatus");
        if (!this.sipSessions.containsValue(jibriSession)) {
            this.getLogger().error("onSessionStateChanged for unknown session: " + jibriSession);
            return;
        }
        this.publishJibriSipCallState(jibriSession, newStatus, failureReason);
        if (JibriIq.Status.OFF == newStatus) {
            String sipAddress = jibriSession.getSipAddress();
            this.sipSessions.remove(sipAddress);
            this.getLogger().info("Removing SIP call: " + sipAddress);
        }
    }

    private final void publishJibriSipCallState(JibriSession session, JibriIq.Status newStatus, JibriIq.FailureReason failureReason) {
        Unit unit;
        SipCallState sipCallState;
        SipCallState $this$publishJibriSipCallState_u24lambda_u241 = sipCallState = new SipCallState();
        boolean bl = false;
        $this$publishJibriSipCallState_u24lambda_u241.setState(newStatus);
        $this$publishJibriSipCallState_u24lambda_u241.setFailureReason(failureReason);
        $this$publishJibriSipCallState_u24lambda_u241.setSipAddress(session.getSipAddress());
        $this$publishJibriSipCallState_u24lambda_u241.setSessionId(session.getSessionId());
        SipCallState sipCallState2 = sipCallState;
        this.getLogger().info("Publishing new state: " + session.getSipAddress() + " " + XmlStringBuilderUtil.Companion.toStringOpt(sipCallState2));
        ChatRoom chatRoom = this.getConference().getChatRoom();
        if (chatRoom != null) {
            chatRoom.setPresenceExtension(sipCallState2);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            this.getLogger().warn("chatRoom is null");
        }
    }
}

