/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.tool.PrettyWriter;

public class RecordedObject {
    private final Object[] objects;
    private final List<ValueDescriptor> descriptors;
    private final TimeConverter timeConverter;

    RecordedObject(List<ValueDescriptor> list, Object[] objectArray, TimeConverter timeConverter) {
        this.descriptors = list;
        this.objects = objectArray;
        this.timeConverter = timeConverter;
    }

    final <T> T getTyped(String string, Class<T> clazz, T t) {
        if (!this.hasField(string)) {
            return t;
        }
        T t2 = this.getValue(string);
        if (t2 == null || t2.getClass().isAssignableFrom(clazz)) {
            return t2;
        }
        return t;
    }

    public boolean hasField(String string) {
        Objects.requireNonNull(string);
        for (ValueDescriptor object : this.descriptors) {
            if (!object.getName().equals(string)) continue;
            return true;
        }
        int n = string.indexOf(".");
        if (n > 0) {
            String string2 = string.substring(0, n);
            for (ValueDescriptor valueDescriptor : this.descriptors) {
                RecordedObject recordedObject;
                if (valueDescriptor.getFields().isEmpty() || !valueDescriptor.getName().equals(string2) || (recordedObject = (RecordedObject)this.getValue(string2)) == null) continue;
                return recordedObject.hasField(string.substring(n + 1));
            }
        }
        return false;
    }

    public final <T> T getValue(String string) {
        Object object = this.getValue(string, false);
        return (T)object;
    }

    private Object getValue(String string, boolean bl) {
        Objects.requireNonNull(string);
        int n = 0;
        for (ValueDescriptor object : this.descriptors) {
            if (string.equals(object.getName())) {
                Object object2 = this.objects[n];
                if (object2 == null) {
                    return null;
                }
                if (object.getFields().isEmpty()) {
                    if (bl && PrivateAccess.getInstance().isUnsigned(object)) {
                        if (object2 instanceof Character || object2 instanceof Long) {
                            return object2;
                        }
                        return new UnsignedValue(object2);
                    }
                    return object2;
                }
                if (object2 instanceof RecordedObject) {
                    return object2;
                }
                Object[] valueDescriptor = (Object[])object2;
                if (object.isArray()) {
                    return this.structifyArray(object, valueDescriptor, 0);
                }
                return new RecordedObject(object.getFields(), (Object[])object2, this.timeConverter);
            }
            ++n;
        }
        int n2 = string.indexOf(".");
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            for (ValueDescriptor valueDescriptor : this.descriptors) {
                if (valueDescriptor.getFields().isEmpty() || !valueDescriptor.getName().equals(string2)) continue;
                RecordedObject recordedObject = (RecordedObject)this.getValue(string2);
                String string3 = string.substring(n2 + 1);
                if (recordedObject != null) {
                    return recordedObject.getValue(string3, bl);
                }
                this.getValueDescriptor(valueDescriptor.getFields(), string3, null);
                throw new NullPointerException("Field value for \"" + string2 + "\" was null. Can't access nested field \"" + string3 + "\"");
            }
        }
        throw new IllegalArgumentException("Could not find field with name " + string);
    }

    private ValueDescriptor getValueDescriptor(List<ValueDescriptor> list, String string, String string2) {
        int n = string.indexOf(".");
        if (n > 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            for (ValueDescriptor valueDescriptor : list) {
                List<ValueDescriptor> list2;
                if (!valueDescriptor.getName().equals(string3) || (list2 = valueDescriptor.getFields()).isEmpty()) continue;
                return this.getValueDescriptor(valueDescriptor.getFields(), string4, string2);
            }
            throw new IllegalArgumentException("Attempt to get unknown field \"" + string3 + "\"");
        }
        for (ValueDescriptor valueDescriptor : list) {
            if (!valueDescriptor.getName().equals(string)) continue;
            if (string2 != null && !valueDescriptor.getTypeName().equals(string2)) {
                throw new IllegalArgumentException("Attempt to get " + valueDescriptor.getTypeName() + " field \"" + string + "\" with illegal data type conversion " + string2);
            }
            return valueDescriptor;
        }
        throw new IllegalArgumentException("\"Attempt to get unknown field \"" + string + "\"");
    }

    private <T> T getTypedValue(String string, String string2) {
        Objects.requireNonNull(string);
        this.getValueDescriptor(this.descriptors, string, string2);
        return this.getValue(string);
    }

    private Object[] structifyArray(ValueDescriptor valueDescriptor, Object[] objectArray, int n) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray[i];
            if (n == 0) {
                if (this.isStackFrameType(valueDescriptor.getTypeName())) {
                    objectArray2[i] = new RecordedFrame(valueDescriptor.getFields(), (Object[])object, this.timeConverter);
                    continue;
                }
                objectArray2[i] = new RecordedObject(valueDescriptor.getFields(), (Object[])object, this.timeConverter);
                continue;
            }
            objectArray2[i] = this.structifyArray(valueDescriptor, (Object[])object, n - 1);
        }
        return objectArray2;
    }

    private boolean isStackFrameType(String string) {
        if ("com.oracle.jfr.types.StackFrame".equals(string)) {
            return true;
        }
        return "jdk.types.StackFrame".equals(string);
    }

    public List<ValueDescriptor> getFields() {
        return this.descriptors;
    }

    public final boolean getBoolean(String string) {
        Object t = this.getValue(string);
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        throw RecordedObject.newIllegalArgumentException(string, "boolean");
    }

    public final byte getByte(String string) {
        Object t = this.getValue(string);
        if (t instanceof Byte) {
            return (Byte)t;
        }
        throw RecordedObject.newIllegalArgumentException(string, "byte");
    }

    public final char getChar(String string) {
        Object t = this.getValue(string);
        if (t instanceof Character) {
            return ((Character)t).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(string, "char");
    }

    public final short getShort(String string) {
        Object object = this.getValue(string, true);
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof UnsignedValue) {
            Object object2 = ((UnsignedValue)object).value();
            if (object2 instanceof Short) {
                return (Short)object2;
            }
            if (object2 instanceof Byte) {
                return (short)Byte.toUnsignedInt((Byte)object2);
            }
        }
        throw RecordedObject.newIllegalArgumentException(string, "short");
    }

    public final int getInt(String string) {
        Object object = this.getValue(string, true);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof UnsignedValue) {
            Object object2 = ((UnsignedValue)object).value();
            if (object2 instanceof Integer) {
                return (Integer)object2;
            }
            if (object2 instanceof Short) {
                return Short.toUnsignedInt((Short)object2);
            }
            if (object2 instanceof Byte) {
                return Byte.toUnsignedInt((Byte)object2);
            }
        }
        throw RecordedObject.newIllegalArgumentException(string, "int");
    }

    public final float getFloat(String string) {
        Object t = this.getValue(string);
        if (t instanceof Float) {
            return ((Float)t).floatValue();
        }
        if (t instanceof Long) {
            return ((Long)t).floatValue();
        }
        if (t instanceof Integer) {
            return ((Integer)t).floatValue();
        }
        if (t instanceof Short) {
            return ((Short)t).floatValue();
        }
        if (t instanceof Byte) {
            return ((Byte)t).byteValue();
        }
        if (t instanceof Character) {
            return ((Character)t).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(string, "float");
    }

    public final long getLong(String string) {
        Object object = this.getValue(string, true);
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).longValue();
        }
        if (object instanceof UnsignedValue) {
            Object object2 = ((UnsignedValue)object).value();
            if (object2 instanceof Integer) {
                return Integer.toUnsignedLong((Integer)object2);
            }
            if (object2 instanceof Short) {
                return Short.toUnsignedLong((Short)object2);
            }
            if (object2 instanceof Byte) {
                return Byte.toUnsignedLong((Byte)object2);
            }
        }
        throw RecordedObject.newIllegalArgumentException(string, "long");
    }

    public final double getDouble(String string) {
        Object t = this.getValue(string);
        if (t instanceof Double) {
            return (Double)t;
        }
        if (t instanceof Float) {
            return ((Float)t).doubleValue();
        }
        if (t instanceof Long) {
            return ((Long)t).doubleValue();
        }
        if (t instanceof Integer) {
            return ((Integer)t).doubleValue();
        }
        if (t instanceof Short) {
            return ((Short)t).doubleValue();
        }
        if (t instanceof Byte) {
            return ((Byte)t).byteValue();
        }
        if (t instanceof Character) {
            return ((Character)t).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(string, "double");
    }

    public final String getString(String string) {
        return (String)this.getTypedValue(string, "java.lang.String");
    }

    public final Duration getDuration(String string) {
        Object t = this.getValue(string);
        if (t instanceof Long) {
            return this.getDuration((Long)t, string);
        }
        if (t instanceof Integer) {
            return this.getDuration(((Integer)t).longValue(), string);
        }
        if (t instanceof Short) {
            return this.getDuration(((Short)t).longValue(), string);
        }
        if (t instanceof Character) {
            return this.getDuration(((Character)t).charValue(), string);
        }
        if (t instanceof Byte) {
            return this.getDuration(((Byte)t).longValue(), string);
        }
        if (t instanceof UnsignedValue) {
            Object object = ((UnsignedValue)t).value();
            if (object instanceof Integer) {
                return this.getDuration(Integer.toUnsignedLong((Integer)object), string);
            }
            if (object instanceof Short) {
                return this.getDuration(Short.toUnsignedLong((Short)object), string);
            }
            if (object instanceof Byte) {
                return this.getDuration(Short.toUnsignedLong(((Byte)object).byteValue()), string);
            }
        }
        throw RecordedObject.newIllegalArgumentException(string, "java,time.Duration");
    }

    private Duration getDuration(long l, String string) throws InternalError {
        ValueDescriptor valueDescriptor = this.getValueDescriptor(this.descriptors, string, null);
        if (l == Long.MIN_VALUE) {
            return Duration.ofSeconds(Long.MIN_VALUE, 0L);
        }
        Timespan timespan = valueDescriptor.getAnnotation(Timespan.class);
        if (timespan != null) {
            switch (timespan.value()) {
                case "MICROSECONDS": {
                    return Duration.ofNanos(1000L * l);
                }
                case "SECONDS": {
                    return Duration.ofSeconds(l);
                }
                case "MILLISECONDS": {
                    return Duration.ofMillis(l);
                }
                case "NANOSECONDS": {
                    return Duration.ofNanos(l);
                }
                case "TICKS": {
                    return Duration.ofNanos(this.timeConverter.convertTimespan(l));
                }
            }
            throw new IllegalArgumentException("Attempt to get " + valueDescriptor.getTypeName() + " field \"" + string + "\" with illegal timespan unit " + timespan.value());
        }
        throw new IllegalArgumentException("Attempt to get " + valueDescriptor.getTypeName() + " field \"" + string + "\" with missing @Timespan");
    }

    public final Instant getInstant(String string) {
        Object object = this.getValue(string, true);
        if (object instanceof Long) {
            return this.getInstant((Long)object, string);
        }
        if (object instanceof Integer) {
            return this.getInstant(((Integer)object).longValue(), string);
        }
        if (object instanceof Short) {
            return this.getInstant(((Short)object).longValue(), string);
        }
        if (object instanceof Character) {
            return this.getInstant(((Character)object).charValue(), string);
        }
        if (object instanceof Byte) {
            return this.getInstant(((Byte)object).longValue(), string);
        }
        if (object instanceof UnsignedValue) {
            Object object2 = ((UnsignedValue)object).value();
            if (object2 instanceof Integer) {
                return this.getInstant(Integer.toUnsignedLong((Integer)object2), string);
            }
            if (object2 instanceof Short) {
                return this.getInstant(Short.toUnsignedLong((Short)object2), string);
            }
            if (object2 instanceof Byte) {
                return this.getInstant(Short.toUnsignedLong(((Byte)object2).byteValue()), string);
            }
        }
        throw RecordedObject.newIllegalArgumentException(string, "java.time.Instant");
    }

    private Instant getInstant(long l, String string) {
        ValueDescriptor valueDescriptor = this.getValueDescriptor(this.descriptors, string, null);
        Timestamp timestamp = valueDescriptor.getAnnotation(Timestamp.class);
        if (timestamp != null) {
            if (l == Long.MIN_VALUE) {
                return Instant.MIN;
            }
            switch (timestamp.value()) {
                case "MILLISECONDS_SINCE_EPOCH": {
                    return Instant.ofEpochMilli(l);
                }
                case "TICKS": {
                    return Instant.ofEpochSecond(0L, this.timeConverter.convertTimestamp(l));
                }
            }
            throw new IllegalArgumentException("Attempt to get " + valueDescriptor.getTypeName() + " field \"" + string + "\" with illegal timestamp unit " + timestamp.value());
        }
        throw new IllegalArgumentException("Attempt to get " + valueDescriptor.getTypeName() + " field \"" + string + "\" with missing @Timestamp");
    }

    public final RecordedClass getClass(String string) {
        return (RecordedClass)this.getTypedValue(string, "java.lang.Class");
    }

    public final RecordedThread getThread(String string) {
        return (RecordedThread)this.getTypedValue(string, "java.lang.Thread");
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrettyWriter prettyWriter = new PrettyWriter(new PrintWriter(stringWriter));
        prettyWriter.setStackDepth(5);
        if (this instanceof RecordedEvent) {
            prettyWriter.print((RecordedEvent)this);
        } else {
            prettyWriter.print(this, "");
        }
        prettyWriter.flush(true);
        return stringWriter.toString();
    }

    OffsetDateTime getOffsetDateTime(String string) {
        Instant instant = this.getInstant(string);
        if (instant.equals(Instant.MIN)) {
            return OffsetDateTime.MIN;
        }
        return OffsetDateTime.ofInstant(this.getInstant(string), this.timeConverter.getZoneOffset());
    }

    private static IllegalArgumentException newIllegalArgumentException(String string, String string2) {
        return new IllegalArgumentException("Attempt to get field \"" + string + "\" with illegal data type conversion " + string2);
    }

    private static final class UnsignedValue {
        private final Object o;

        UnsignedValue(Object object) {
            this.o = object;
        }

        Object value() {
            return this.o;
        }
    }
}

