/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Action;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.ContextualActionsFactory;

public class ContextualActionsFactoryService {
    protected static final ContextualActionsFactoryService CONTEXTUAL_ACTIONS_FACTORY_SERVICE = new ContextualActionsFactoryService();
    protected static final ActionNameComparator COMPARATOR = new ActionNameComparator();
    protected final Collection<ContextualActionsFactory> providers = ExtensionService.getInstance().load(ContextualActionsFactory.class);

    public static ContextualActionsFactoryService getInstance() {
        return CONTEXTUAL_ACTIONS_FACTORY_SERVICE;
    }

    public Collection<Action> get(API api, Container.Entry entry, String fragment) {
        HashMap<String, ArrayList<Action>> mapActions = new HashMap<String, ArrayList<Action>>();
        for (ContextualActionsFactory provider : this.providers) {
            Collection<Action> actions = provider.make(api, entry, fragment);
            for (Action action : actions) {
                String groupName = (String)action.getValue("GroupNameKey");
                ArrayList<Action> list = (ArrayList<Action>)mapActions.get(groupName);
                if (list == null) {
                    list = new ArrayList<Action>();
                    mapActions.put(groupName, list);
                }
                list.add(action);
            }
        }
        if (!mapActions.isEmpty()) {
            ArrayList<Action> result = new ArrayList<Action>();
            ArrayList groupNames = new ArrayList(mapActions.keySet());
            Collections.sort(groupNames);
            for (String groupName : groupNames) {
                if (!result.isEmpty()) {
                    result.add(null);
                }
                ArrayList actions = (ArrayList)mapActions.get(groupName);
                Collections.sort(actions, COMPARATOR);
                result.addAll(actions);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected static class ActionNameComparator
    implements Comparator<Action> {
        protected ActionNameComparator() {
        }

        @Override
        public int compare(Action a1, Action a2) {
            String n2;
            String n1 = (String)a1.getValue("Name");
            if (n1 == null) {
                n1 = "";
            }
            if ((n2 = (String)a2.getValue("Name")) == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }
}

