/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.control;

import org.cybergarage.http.HTTPRequest;
import org.cybergarage.soap.SOAP;
import org.cybergarage.soap.SOAPResponse;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.control.ActionResponse;
import org.cybergarage.upnp.control.ControlRequest;
import org.cybergarage.xml.Node;

public class ActionRequest
extends ControlRequest {
    public ActionRequest() {
    }

    public ActionRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    public Node getActionNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        if (!bodyNode.hasNodes()) {
            return null;
        }
        return bodyNode.getNode(0);
    }

    public String getActionName() {
        Node node = this.getActionNode();
        if (node == null) {
            return "";
        }
        String name = node.getName();
        if (name == null) {
            return "";
        }
        int idx = name.indexOf(":") + 1;
        if (idx < 0) {
            return "";
        }
        return name.substring(idx, name.length());
    }

    public ArgumentList getArgumentList() {
        Node actNode = this.getActionNode();
        int nArgNodes = actNode.getNNodes();
        ArgumentList argList = new ArgumentList();
        for (int n = 0; n < nArgNodes; ++n) {
            Argument arg = new Argument();
            Node argNode = actNode.getNode(n);
            arg.setName(argNode.getName());
            arg.setValue(argNode.getValue());
            argList.add(arg);
        }
        return argList;
    }

    public void setRequest(Action action, ArgumentList argList) {
        Service service = action.getService();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node envNode = this.getEnvelopeNode();
        Node bodyNode = this.getBodyNode();
        Node argNode = this.createContentNode(service, action, argList);
        bodyNode.addNode(argNode);
        this.setContent(envNode);
        String serviceType = service.getServiceType();
        String actionName = action.getName();
        String soapAction = "\"" + serviceType + "#" + actionName + "\"";
        this.setSOAPAction(soapAction);
    }

    private Node createContentNode(Service service, Action action, ArgumentList argList) {
        String actionName = action.getName();
        String serviceType = service.getServiceType();
        Node actionNode = new Node();
        actionNode.setName("u", actionName);
        actionNode.setNameSpace("u", serviceType);
        int argListCnt = argList.size();
        for (int n = 0; n < argListCnt; ++n) {
            Argument arg = argList.getArgument(n);
            Node argNode = new Node();
            argNode.setName(arg.getName());
            argNode.setValue(arg.getValue());
            actionNode.addNode(argNode);
        }
        return actionNode;
    }

    public ActionResponse post() {
        SOAPResponse soapRes = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new ActionResponse(soapRes);
    }
}

