/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;

public class PooledTunnelCreatorConfig
extends TunnelCreatorConfig {
    private final TunnelPool _pool;
    private TunnelId _pairedGW;

    public PooledTunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound, Hash destination, TunnelPool pool) {
        super(ctx, length, isInbound, destination);
        this._pool = pool;
    }

    public void testJobSuccessful(int ms) {
        this.testSuccessful(ms);
    }

    @Override
    public boolean tunnelFailed() {
        boolean rv = super.tunnelFailed();
        if (!rv) {
            this._pool.tunnelFailed(this);
        }
        return rv;
    }

    public void tunnelFailedFirstHop() {
        if (this.isInbound() || this.getLength() <= 1) {
            return;
        }
        this.tunnelFailedCompletely();
        this._pool.tunnelFailed(this, this.getPeer(1));
    }

    @Override
    public Properties getOptions() {
        return this._pool.getSettings().getUnknownOptions();
    }

    public TunnelPool getTunnelPool() {
        return this._pool;
    }

    public void setPairedGW(TunnelId gw) {
        this._pairedGW = gw;
    }

    public TunnelId getPairedGW() {
        return this._pairedGW;
    }
}

