/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.HandshakeState;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.ratchet.NextSessionKey;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.SessionKeyAndNonce;
import net.i2p.router.crypto.ratchet.SessionTagListener;
import net.i2p.router.crypto.ratchet.SparseArray;
import net.i2p.util.Log;

class RatchetTagSet
implements TagSetHandle {
    private final SessionTagListener _lsnr;
    private final PublicKey _remoteKey;
    protected final SessionKey _key;
    private final SessionKey _tagsetKey;
    private final HandshakeState _state;
    private final SparseArray<RatchetSessionTag> _sessionTags;
    private final SparseArray<byte[]> _sessionKeys;
    private final HKDF hkdf;
    private final long _created;
    private final long _timeout;
    private long _date;
    private final int _id;
    private final int _keyid;
    private final int _originalSize;
    private final int _maxSize;
    private boolean _acked;
    private final byte[] _nextRootKey;
    private final byte[] _sesstag_ck;
    private final byte[] _sesstag_constant;
    private final byte[] _symmkey_ck;
    private final byte[] _symmkey_constant;
    private int _lastTag = -1;
    private int _lastKey = -1;
    private KeyPair _nextKeys;
    private NextSessionKey _nextKey;
    private boolean _nextKeyAcked;
    private static final AtomicInteger __tagSetID = new AtomicInteger();
    private final int _tagSetID = __tagSetID.incrementAndGet();
    private static final String INFO_1 = "KDFDHRatchetStep";
    private static final String INFO_2 = "TagAndKeyGenKeys";
    private static final String INFO_3 = "STInitialization";
    private static final String INFO_4 = "SessionTagKeyGen";
    private static final String INFO_5 = "SymmetricRatchet";
    private static final byte[] ZEROLEN = new byte[0];
    private static final int TAGLEN = 8;
    private static final int MAX = 65535;
    private static final boolean DEBUG = false;
    private static final boolean TEST_RATCHET = false;
    private static final int LOW = 61439;
    static final int DEBUG_OB_NSR = 65537;
    static final int DEBUG_IB_NSR = 65538;
    static final int DEBUG_SINGLE_ES = 65539;
    private static final int INITIAL_KEY_CAPACITY = 0;

    public RatchetTagSet(HKDF hkdf, HandshakeState state, SessionKey rootKey, SessionKey data, long date) {
        this(hkdf, null, state, null, rootKey, data, date, 180000L, 65537, -2, false, 0, 0);
    }

    public RatchetTagSet(HKDF hkdf, SessionKey rootKey, SessionKey data, long date, int tagsetid, int keyid) {
        this(hkdf, null, null, null, rootKey, data, date, 480000L, tagsetid, keyid, false, 0, 0);
    }

    public RatchetTagSet(HKDF hkdf, SessionTagListener lsnr, HandshakeState state, SessionKey rootKey, SessionKey data, long date, int minSize, int maxSize) {
        this(hkdf, lsnr, state, null, rootKey, data, date, 180000L, 65538, -2, true, minSize, maxSize);
    }

    public RatchetTagSet(HKDF hkdf, SessionTagListener lsnr, PublicKey remoteKey, SessionKey rootKey, SessionKey data, long date, int tagsetid, int keyid, int minSize, int maxSize) {
        this(hkdf, lsnr, null, remoteKey, rootKey, data, date, 600000L, tagsetid, keyid, true, minSize, maxSize);
    }

    private RatchetTagSet(HKDF hkdf, SessionTagListener lsnr, HandshakeState state, PublicKey remoteKey, SessionKey rootKey, SessionKey data, long date, long timeout, int tagsetid, int keyid, boolean isInbound, int minSize, int maxSize) {
        this._lsnr = lsnr;
        this._state = state;
        this._remoteKey = remoteKey;
        this._key = rootKey;
        this._tagsetKey = data;
        this._created = date;
        this._timeout = timeout;
        this._date = date;
        this._id = tagsetid;
        this._keyid = keyid;
        this._originalSize = minSize;
        this._maxSize = maxSize;
        this._nextRootKey = new byte[32];
        byte[] ck = new byte[32];
        this._sesstag_ck = new byte[32];
        this._sesstag_constant = new byte[32];
        this._symmkey_ck = new byte[32];
        this._symmkey_constant = ZEROLEN;
        this.hkdf = hkdf;
        hkdf.calculate(rootKey.getData(), data.getData(), INFO_1, this._nextRootKey, ck, 0);
        hkdf.calculate(ck, ZEROLEN, INFO_2, this._sesstag_ck, this._symmkey_ck, 0);
        hkdf.calculate(this._sesstag_ck, ZEROLEN, INFO_3, this._sesstag_ck, this._sesstag_constant, 0);
        if (isInbound) {
            this._sessionTags = new SparseArray(minSize);
            this._sessionKeys = state == null ? new SparseArray(0) : null;
            for (int i = 0; i < minSize; ++i) {
                this.storeNextTag();
            }
        } else {
            this._sessionTags = null;
            this._sessionKeys = null;
        }
        if (tagsetid > 0 && tagsetid <= 65535) {
            this._acked = true;
        }
    }

    protected RatchetTagSet(SessionTagListener lsnr, SessionKey rootKey, long date, long timeout) {
        this._lsnr = lsnr;
        this._state = null;
        this._remoteKey = null;
        this._key = rootKey;
        this._tagsetKey = null;
        this._created = date;
        this._timeout = timeout;
        this._date = date;
        this._id = 65539;
        this._keyid = -3;
        this._originalSize = 1;
        this._maxSize = 1;
        this._nextRootKey = null;
        this._sesstag_ck = null;
        this._sesstag_constant = null;
        this._symmkey_ck = null;
        this._symmkey_constant = null;
        this.hkdf = null;
        this._sessionTags = null;
        this._sessionKeys = null;
        this._acked = true;
    }

    public void clear() {
        if (this._sessionTags != null) {
            this._sessionTags.clear();
        }
        if (this._sessionKeys != null) {
            this._sessionKeys.clear();
        }
    }

    public PublicKey getRemoteKey() {
        DHState kp;
        if (this._state != null && (kp = this._state.getRemotePublicKey()) != null) {
            byte[] rv = new byte[32];
            kp.getPublicKey(rv, 0);
            return new PublicKey(EncType.ECIES_X25519, rv);
        }
        return this._remoteKey;
    }

    public SessionKey getAssociatedKey() {
        return this._key;
    }

    public HandshakeState getHandshakeState() {
        return this._state;
    }

    public long getDate() {
        return this._date;
    }

    public void setDate(long when) {
        this._date = when;
    }

    public long getCreated() {
        return this._created;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public synchronized long getExpiration() {
        if (this._acked) {
            return this._date + this._timeout;
        }
        return this._created + Math.min(this._timeout, 180000L);
    }

    public synchronized int size() {
        return this._sessionTags != null ? this._sessionTags.size() : 0;
    }

    public synchronized int remaining() {
        int nextKey = this._lastTag + 1;
        if (this._sessionTags != null) {
            nextKey -= this._sessionTags.size();
        }
        return 65536 - nextKey;
    }

    public NextSessionKey getNextKey() {
        if (this._sessionTags != null || this._state != null || this.remaining() > 61439) {
            return null;
        }
        if (this._nextKey == null) {
            boolean isFirst;
            boolean bl = isFirst = this._id == 0;
            if (isFirst || (this._id & 1) != 0) {
                this._nextKeys = ((RouterContext)I2PAppContext.getGlobalContext()).commSystem().getXDHFactory().getKeys();
                this._nextKey = new NextSessionKey(this._nextKeys.getPublic().getData(), this._keyid + 1, false, isFirst);
            } else {
                this._nextKey = new NextSessionKey(this._keyid, false, true);
            }
        }
        return this._nextKey;
    }

    public KeyPair getNextKeys() {
        return this._nextKeys;
    }

    public SessionKey getNextRootKey() {
        return new SessionKey(this._nextRootKey);
    }

    public SessionKeyAndNonce consume(RatchetSessionTag tag) {
        if (this._sessionTags == null) {
            throw new IllegalStateException("Outbound tagset");
        }
        int idx = this._sessionTags.indexOfValueByValue(tag);
        if (idx < 0) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(RatchetTagSet.class);
            if (log.shouldWarn()) {
                log.warn("Tag not found " + tag.toBase64() + " in:\n" + this.toString(), new Exception());
            }
            return null;
        }
        this._acked = true;
        int tagnum = this._sessionTags.keyAt(idx);
        this._sessionTags.removeAt(idx);
        if (this._state != null) {
            this.addTags(tagnum);
            return new SessionKeyAndNonce(this._state);
        }
        int kidx = this._sessionKeys.indexOfKey(tagnum);
        if (kidx >= 0) {
            byte[] rv = this._sessionKeys.valueAt(kidx);
            this._sessionKeys.removeAt(kidx);
            this.addTags(tagnum);
            return new SessionKeyAndNonce(rv, this._id, tagnum, this._remoteKey);
        }
        if (tagnum > this._lastKey) {
            for (int i = this._lastKey + 1; i < tagnum; ++i) {
                this._sessionKeys.append(i, this.consumeNextKey().getData());
            }
            SessionKeyAndNonce rv = this.consumeNextKey();
            this.addTags(tagnum);
            return rv;
        }
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(RatchetTagSet.class);
        if (log.shouldWarn()) {
            log.warn("No key found for tag " + tag.toBase64() + " at index " + idx + " tagnum = " + tagnum + " lastkey = " + this._lastKey, new Exception());
        }
        return null;
    }

    private void addTags(int usedTagNumber) {
        int tooOld;
        int trimBehind;
        int lookAhead;
        if (this._maxSize > this._originalSize) {
            trimBehind = lookAhead = Math.min(this._maxSize, this._originalSize + usedTagNumber / 2);
        } else {
            lookAhead = this._originalSize;
            trimBehind = this._originalSize;
        }
        int remaining = this._lastTag - usedTagNumber;
        int toAdd = lookAhead - remaining;
        if (toAdd > 0) {
            for (int i = 0; i < toAdd; ++i) {
                this.storeNextTag();
            }
        }
        if ((tooOld = usedTagNumber - trimBehind) > 0) {
            int tagnum;
            int toTrim = 0;
            while ((tagnum = this._sessionTags.keyAt(toTrim)) < tooOld) {
                int kidx;
                if (this._sessionKeys != null && (kidx = this._sessionKeys.indexOfKey(tagnum)) >= 0) {
                    this._sessionKeys.removeAt(kidx);
                }
                if (this._lsnr != null) {
                    this._lsnr.expireTag(this._sessionTags.valueAt(toTrim), this);
                }
                ++toTrim;
            }
            if (toTrim > 0) {
                this._sessionTags.removeAtRange(0, toTrim);
            }
        }
    }

    private void storeNextTag() {
        RatchetSessionTag tag = this.consumeNext();
        if (tag == null) {
            return;
        }
        this._sessionTags.append(this._lastTag, tag);
        if (this._lsnr != null) {
            this._lsnr.addTag(tag, this);
        }
    }

    public RatchetSessionTag consumeNext() {
        if (this._lastTag >= 65535) {
            return null;
        }
        byte[] tmp = new byte[32];
        this.hkdf.calculate(this._sesstag_ck, this._sesstag_constant, INFO_4, this._sesstag_ck, tmp, 0);
        ++this._lastTag;
        return new RatchetSessionTag(tmp);
    }

    public SessionKeyAndNonce consumeNextKey() {
        if (this._state != null) {
            return new SessionKeyAndNonce(this._state);
        }
        byte[] key = new byte[32];
        this.hkdf.calculate(this._symmkey_ck, this._symmkey_constant, INFO_5, this._symmkey_ck, key, 0);
        ++this._lastKey;
        if (this._sessionTags == null && this._lastKey == 0) {
            this._acked = true;
        }
        return new SessionKeyAndNonce(key, this._id, this._lastKey, this._remoteKey);
    }

    public boolean getAcked() {
        return this._acked;
    }

    public int getID() {
        return this._id;
    }

    public int getDebugID() {
        return this._tagSetID;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder(256);
        if (this._sessionTags != null) {
            buf.append("Inbound ");
        } else {
            buf.append("Outbound ");
        }
        if (this._state != null) {
            buf.append("NSR ");
        } else {
            buf.append("ES ");
        }
        buf.append("TagSet #").append(this._tagSetID).append(" ID #").append(this._id).append("\nCreated:  ").append(DataHelper.formatTime(this._created)).append("\nLast use: ").append(DataHelper.formatTime(this._date));
        PublicKey pk = this.getRemoteKey();
        if (pk != null) {
            buf.append("\nRemote Public Key: ").append(pk.toBase64());
        }
        buf.append("\nRoot Key:   ").append(this._key.toBase64());
        if (this._tagsetKey != null) {
            buf.append("\nTagset Key: ").append(this._tagsetKey.toBase64());
        }
        if (this._nextKey != null) {
            buf.append("\nNext Key:   ").append(this._nextKey);
        }
        int sz = this.size();
        buf.append("\nSize: ").append(sz).append(" Orig: ").append(this._originalSize).append(" Max: ").append(this._maxSize).append(" Remaining: ").append(this.remaining());
        buf.append(" Acked? ").append(this._acked);
        if (this._sessionTags != null) {
            for (int i = 0; i < sz; ++i) {
                int n = this._sessionTags.keyAt(i);
                RatchetSessionTag tag = this._sessionTags.valueAt(i);
                if (tag == null) continue;
                buf.append("\n  ").append(n).append('\t').append(tag.toBase64());
                if (this._sessionKeys == null) continue;
                byte[] key = this._sessionKeys.get(n);
                if (key != null) {
                    buf.append('\t').append(Base64.encode(key));
                    continue;
                }
                buf.append("\tTBD");
                buf.append(" (" + (sz - (i + 1)) + " more)");
                break;
            }
        }
        return buf.toString();
    }
}

