/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.router;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.PrivateKeyFile;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.router.RouterIdentity;

public class RouterPrivateKeyFile
extends PrivateKeyFile {
    public RouterPrivateKeyFile(File file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterIdentity getRouterIdentity() throws IOException, DataFormatException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.file));
            RouterIdentity ri = new RouterIdentity();
            ri.readBytes(in);
            EncType etype = ri.getPublicKey().getType();
            if (etype == null) {
                throw new DataFormatException("Unknown enc type");
            }
            this.privKey = new PrivateKey(etype);
            this.privKey.readBytes(in);
            SigType type = ri.getSigningPublicKey().getType();
            if (type == null) {
                throw new DataFormatException("Unknown sig type");
            }
            this.signingPrivKey = new SigningPrivateKey(type);
            this.signingPrivKey.readBytes(in);
            this.dest = new Destination();
            this.dest.setPublicKey(ri.getPublicKey());
            this.dest.setSigningPublicKey(ri.getSigningPublicKey());
            this.dest.setCertificate(ri.getCertificate());
            this.dest.setPadding(ri.getPadding());
            RouterIdentity routerIdentity = ri;
            return routerIdentity;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

