/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public abstract class TunnelBuildMessageBase
extends I2NPMessageImpl {
    protected EncryptedBuildRecord[] _records;
    protected int RECORD_COUNT;
    public static final int MAX_RECORD_COUNT = 8;
    public static final int RECORD_SIZE = 528;

    public TunnelBuildMessageBase(I2PAppContext context) {
        this(context, 8);
    }

    protected TunnelBuildMessageBase(I2PAppContext context, int records) {
        super(context);
        if (records > 0) {
            this.RECORD_COUNT = records;
            this._records = new EncryptedBuildRecord[records];
        }
    }

    public void setRecord(int index, EncryptedBuildRecord record) {
        this._records[index] = record;
    }

    public EncryptedBuildRecord getRecord(int index) {
        return this._records[index];
    }

    public int getRecordCount() {
        return this.RECORD_COUNT;
    }

    @Override
    protected int calculateWrittenLength() {
        return 528 * this.RECORD_COUNT;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != this.getType()) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            int off = offset + i * 528;
            byte[] rec = new byte[528];
            System.arraycopy(data, off, rec, 0, 528);
            this.setRecord(i, new EncryptedBuildRecord(rec));
        }
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            System.arraycopy(this._records[i].getData(), 0, out, curIndex, 528);
            curIndex += 528;
        }
        return curIndex;
    }
}

