/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import net.i2p.data.DataHelper;

@Deprecated
public abstract class ZipFileComment {
    private static final int BLOCK_LEN = 22;
    private static final byte[] magicStart = new byte[]{80, 75, 3, 4};
    private static final int HEADER_LEN = magicStart.length;
    private static final byte[] magicDirEnd = new byte[]{80, 75, 5, 6};
    private static final int MAGIC_LEN = magicDirEnd.length;

    public static String getComment(File file, int max) throws IOException {
        return ZipFileComment.getComment(file, max, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComment(File file, int max, int skip) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        long len = file.length();
        if (len < (long)(22 + HEADER_LEN + skip)) {
            throw new ZipException("File too short: " + file);
        }
        if (len > Integer.MAX_VALUE) {
            throw new ZipException("File too long: " + file);
        }
        int fileLen = (int)len;
        byte[] buffer = new byte[Math.min(fileLen - skip, max + 22)];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            if (skip > 0) {
                DataHelper.skip(in, skip);
            }
            byte[] hdr = new byte[HEADER_LEN];
            DataHelper.read(in, hdr);
            if (!DataHelper.eq(hdr, magicStart)) {
                throw new ZipException("Not a zip file: " + file);
            }
            DataHelper.skip(in, fileLen - (skip + HEADER_LEN + buffer.length));
            DataHelper.read(in, buffer);
            String string = ZipFileComment.getComment(buffer);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getComment(byte[] buffer) throws IOException {
        for (int i = buffer.length - (23 - MAGIC_LEN); i >= 0; --i) {
            if (!DataHelper.eq(buffer, i, magicDirEnd, 0, MAGIC_LEN)) continue;
            int commentLen = (buffer[i + 22 - 2] & 0xFF) + (buffer[i + 22 - 1] & 0xFF) * 256;
            return new String(buffer, i + 22, commentLen, "UTF-8");
        }
        throw new ZipException("No comment block found");
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: ZipFileComment file");
            return;
        }
        int skip = 0;
        String file = args[0];
        if (file.endsWith(".sud") || file.endsWith(".su2")) {
            skip = 56;
        }
        String c = ZipFileComment.getComment(new File(file), 256, skip);
        System.out.println("comment is: \"" + c + '\"');
    }
}

