/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.net.SocketTimeoutException;

class TimeoutPipedInputStream
extends PipedInputStream {
    private int timeout;
    private boolean _closedByWriter;
    private volatile boolean _closedByReader;

    public TimeoutPipedInputStream(int pipeSize) {
        super(pipeSize);
    }

    @Override
    public synchronized int read() throws IOException {
        block5: {
            if (this.in < 0 && this.timeout > 0 && !this._closedByReader) {
                long now = System.currentTimeMillis();
                long end = now + (long)this.timeout;
                do {
                    if (this._closedByWriter) {
                        return -1;
                    }
                    try {
                        this.wait(Math.max(1L, Math.min(1000L, end - now)));
                    }
                    catch (InterruptedException ex) {
                        throw new InterruptedIOException();
                    }
                    if (this.in >= 0 || this._closedByReader) break block5;
                } while ((now = System.currentTimeMillis()) < end);
                throw new SocketTimeoutException();
            }
        }
        return super.read();
    }

    public void setReadTimeout(int ms) {
        this.timeout = Math.max(0, ms);
    }

    synchronized void x_receivedLast() {
        this._closedByWriter = true;
        this.notifyAll();
    }

    @Override
    public void close() throws IOException {
        this._closedByReader = true;
        super.close();
    }
}

