/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class RFC822Date {
    private static final SimpleDateFormat OUTPUT_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat[] rfc822DateFormats = new SimpleDateFormat[]{OUTPUT_FORMAT, new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.US)};

    public static synchronized long parse822Date(String s) {
        for (int i = 0; i < rfc822DateFormats.length; ++i) {
            try {
                Date date = rfc822DateFormats[i].parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static synchronized String to822Date(long t) {
        return OUTPUT_FORMAT.format(new Date(t));
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                System.out.println(RFC822Date.to822Date(Long.parseLong(args[0]) * 1000L));
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid date");
                System.out.println(nfe.toString());
            }
        } else if (args.length == 0) {
            long t = System.currentTimeMillis();
            System.out.println("Current Time: " + t / 1000L);
            System.out.println(RFC822Date.to822Date(t));
        } else {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                buf.append(args[i]);
                if (i >= args.length - 1) continue;
                buf.append(' ');
            }
            long t = RFC822Date.parse822Date(buf.toString());
            if (t >= 0L) {
                System.out.println(Long.toString(t / 1000L));
            } else {
                System.out.println("Invalid date");
                System.out.println("Usage: RFC822Date [numericDate|textualDate]");
            }
        }
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("GMT");
        for (int i = 0; i < rfc822DateFormats.length; ++i) {
            rfc822DateFormats[i].setTimeZone(utc);
        }
    }
}

