/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.graph.AnySelectionPredicate;
import org.eclipse.jetty.start.graph.GraphException;
import org.eclipse.jetty.start.graph.Node;
import org.eclipse.jetty.start.graph.NodeDepthComparator;
import org.eclipse.jetty.start.graph.OnlyTransitivePredicate;
import org.eclipse.jetty.start.graph.Predicate;
import org.eclipse.jetty.start.graph.Selection;

public abstract class Graph<T extends Node<T>>
implements Iterable<T> {
    private String selectionTerm = "select";
    private String nodeTerm = "node";
    private Map<String, T> nodes = new LinkedHashMap<String, T>();
    private int maxDepth = -1;

    protected Set<String> asNameSet(Set<T> nodeSet) {
        HashSet<String> ret = new HashSet<String>();
        for (Node node : nodeSet) {
            ret.add(node.getName());
        }
        return ret;
    }

    private void assertNoCycle(T node, Stack<String> refs) {
        for (Node parent : ((Node)node).getParentEdges()) {
            if (refs.contains(parent.getName())) {
                StringBuilder err = new StringBuilder();
                err.append("A cyclic reference in the ");
                err.append(this.getClass().getSimpleName());
                err.append(" has been detected: ");
                for (int i = 0; i < refs.size(); ++i) {
                    if (i > 0) {
                        err.append(" -> ");
                    }
                    err.append((String)refs.get(i));
                }
                err.append(" -> ").append(parent.getName());
                throw new IllegalStateException(err.toString());
            }
            refs.push(parent.getName());
            this.assertNoCycle(parent, refs);
            refs.pop();
        }
    }

    private void bfsCalculateDepth(T node, int depthNow) {
        int depth = depthNow + 1;
        for (Node child : ((Node)node).getChildEdges()) {
            child.setDepth(Math.max(depth, child.getDepth()));
            this.maxDepth = Math.max(this.maxDepth, child.getDepth());
        }
        for (Node child : ((Node)node).getChildEdges()) {
            this.bfsCalculateDepth(child, depth);
        }
    }

    public void buildGraph() throws FileNotFoundException, IOException {
        ArrayList<T> nodeList = new ArrayList<T>(this.nodes.values());
        for (Node node : nodeList) {
            for (String parentName : node.getParentNames()) {
                Node parent = this.get(parentName);
                if (parent == null) {
                    parent = this.resolveNode(parentName);
                }
                if (parent == null) {
                    if (Props.hasPropertyKey(parentName)) {
                        StartLog.debug("Module property not expandable (yet) [%s]", parentName);
                        continue;
                    }
                    StartLog.warn("Module not found [%s]", parentName);
                    continue;
                }
                node.addParentEdge(parent);
                parent.addChildEdge((Node)node);
            }
            for (String optionalParentName : node.getOptionalParentNames()) {
                Node optional = this.get(optionalParentName);
                if (optional == null) {
                    StartLog.debug("Optional module not found [%s]", optionalParentName);
                    continue;
                }
                if (!optional.isSelected()) continue;
                node.addParentEdge(optional);
                optional.addChildEdge((Node)node);
            }
        }
        Stack<String> refs = new Stack<String>();
        for (Node module : this.nodes.values()) {
            refs.push(module.getName());
            this.assertNoCycle(module, refs);
            refs.pop();
        }
        for (Node module : this.nodes.values()) {
            if (!module.getParentEdges().isEmpty()) continue;
            this.bfsCalculateDepth(module, 0);
        }
    }

    public boolean containsNode(String name) {
        return this.nodes.containsKey(name);
    }

    public int count() {
        return this.nodes.size();
    }

    public void dumpSelectedTree() {
        ArrayList<T> ordered = new ArrayList<T>();
        ordered.addAll(this.nodes.values());
        Collections.sort(ordered, new NodeDepthComparator());
        List<T> active = this.getSelected();
        for (Node module : ordered) {
            if (!active.contains(module)) continue;
            String indent = this.toIndent(module.getDepth());
            boolean transitive = module.matches(OnlyTransitivePredicate.INSTANCE);
            System.out.printf("%s + %s: %s [%s]%n", indent, this.toCap(this.nodeTerm), module.getName(), transitive ? "transitive" : "selected");
        }
    }

    public void dumpSelected() {
        ArrayList<T> ordered = new ArrayList<T>();
        ordered.addAll(this.nodes.values());
        Collections.sort(ordered, new NodeDepthComparator());
        List<T> active = this.getSelected();
        for (Node module : ordered) {
            if (!active.contains(module)) continue;
            boolean transitive = module.matches(OnlyTransitivePredicate.INSTANCE);
            System.out.printf("  %3d) %-15s ", module.getDepth() + 1, module.getName());
            if (transitive) {
                System.out.println("<transitive> ");
                continue;
            }
            ArrayList<String> criterias = new ArrayList<String>();
            for (Selection selection : module.getSelections()) {
                if (!selection.isExplicit()) continue;
                criterias.add(selection.getCriteria());
            }
            Collections.sort(criterias);
            System.out.println(Utils.join(criterias, ", "));
        }
    }

    protected void findChildren(T module, Set<T> ret) {
        ret.add(module);
        for (Node child : ((Node)module).getChildEdges()) {
            ret.add(child);
        }
    }

    protected void findParents(T module, Map<String, T> ret) {
        ret.put(((Node)module).getName(), module);
        for (Node parent : ((Node)module).getParentEdges()) {
            ret.put(parent.getName(), parent);
            this.findParents(parent, ret);
        }
    }

    public T get(String name) {
        return (T)((Node)this.nodes.get(name));
    }

    public List<T> getSelected() {
        return this.getMatching(new AnySelectionPredicate());
    }

    public List<T> getMatching(Predicate predicate) {
        ArrayList<Node> selected = new ArrayList<Node>();
        for (Node node : this.nodes.values()) {
            if (!predicate.match(node)) continue;
            selected.add(node);
        }
        Collections.sort(selected, new NodeDepthComparator());
        return selected;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Set<T> getModulesAtDepth(int depth) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            if (node.getDepth() != depth) continue;
            ret.add(node);
        }
        return ret;
    }

    public Collection<String> getNodeNames() {
        return this.nodes.keySet();
    }

    public Collection<T> getNodes() {
        return this.nodes.values();
    }

    public String getNodeTerm() {
        return this.nodeTerm;
    }

    public String getSelectionTerm() {
        return this.selectionTerm;
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodes.values().iterator();
    }

    public abstract void onNodeSelected(T var1);

    public T register(T node) {
        StartLog.debug("Registering Node: [%s] %s", ((Node)node).getName(), node);
        this.nodes.put(((Node)node).getName(), node);
        return node;
    }

    public Set<String> resolveChildNodesOf(String nodeName) {
        HashSet ret = new HashSet();
        T module = this.get(nodeName);
        this.findChildren(module, ret);
        return this.asNameSet(ret);
    }

    public abstract T resolveNode(String var1);

    public Set<String> resolveParentModulesOf(String nodeName) {
        HashMap ret = new HashMap();
        T node = this.get(nodeName);
        this.findParents(node, ret);
        return ret.keySet();
    }

    public int selectNode(Predicate nodePredicate, Selection selection) {
        int count = 0;
        List<T> matches = this.getMatching(nodePredicate);
        if (matches.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("WARNING: Cannot ").append(this.selectionTerm);
            err.append(" requested ").append(this.nodeTerm);
            err.append("s.  ").append(nodePredicate);
            err.append(" returned no matches.");
            StartLog.warn(err.toString(), new Object[0]);
            return count;
        }
        for (Node node : matches) {
            count += this.selectNode(node, selection);
        }
        return count;
    }

    public int selectNode(String name, Selection selection) {
        int count = 0;
        T node = this.get(name);
        if (node == null) {
            StringBuilder err = new StringBuilder();
            err.append("Cannot ").append(this.selectionTerm);
            err.append(" requested ").append(this.nodeTerm);
            err.append(" [").append(name).append("]: not a valid ");
            err.append(this.nodeTerm).append(" name.");
            StartLog.warn(err.toString(), new Object[0]);
            return count;
        }
        return count += this.selectNode(node, selection);
    }

    private int selectNode(T node, Selection selection) {
        int count = 0;
        if (((Node)node).getSelections().contains(selection)) {
            return count;
        }
        StartLog.debug("%s %s: %s (via %s)", this.toCap(this.selectionTerm), this.nodeTerm, ((Node)node).getName(), selection);
        boolean newlySelected = ((Node)node).getSelections().isEmpty();
        ((Node)node).addSelection(selection);
        if (newlySelected) {
            this.onNodeSelected(node);
        }
        ++count;
        Selection transitive = selection.asTransitive();
        ArrayList<String> parentNames = new ArrayList<String>();
        parentNames.addAll(((Node)node).getParentNames());
        return count += this.selectNodes(parentNames, transitive);
    }

    public int selectNodes(Collection<String> names, Selection selection) {
        StartLog.debug("%s [%s] (via %s)", this.toCap(this.selectionTerm), Utils.join(names, ", "), selection);
        int count = 0;
        for (String name : names) {
            T node = this.get(name);
            if (node == null) {
                StartLog.debug("resolving node [%s]", name);
                node = this.resolveNode(name);
            }
            if (node == null) {
                throw new GraphException("Missing referenced dependency: " + name);
            }
            count += this.selectNode(((Node)node).getName(), selection);
        }
        return count;
    }

    public void setNodeTerm(String nodeTerm) {
        this.nodeTerm = nodeTerm;
    }

    public void setSelectionTerm(String selectionTerm) {
        this.selectionTerm = selectionTerm;
    }

    private String toCap(String str) {
        StringBuilder cap = new StringBuilder();
        cap.append(Character.toUpperCase(str.charAt(0)));
        cap.append(str.substring(1));
        return cap.toString();
    }

    private String toIndent(int depth) {
        char[] indent = new char[depth * 2];
        Arrays.fill(indent, ' ');
        return new String(indent);
    }
}

