/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.InstrumentedGroovyCallsTracker;

@NonNullApi
public class PerThreadInstrumentedGroovyCallsTracker
implements InstrumentedGroovyCallsTracker {
    private final ThreadLocal<InstrumentedGroovyCallsTracker> perThreadImplementation;

    public PerThreadInstrumentedGroovyCallsTracker(Supplier<InstrumentedGroovyCallsTracker> implementationSupplier) {
        this.perThreadImplementation = ThreadLocal.withInitial(implementationSupplier);
    }

    @Override
    public InstrumentedGroovyCallsTracker.EntryPointCallSite enterCall(String callerClassName, String callableName, InstrumentedGroovyCallsTracker.CallKind callKind) {
        return this.perThreadImplementation.get().enterCall(callerClassName, callableName, callKind);
    }

    @Override
    public void leaveCall(InstrumentedGroovyCallsTracker.EntryPointCallSite entryPoint) {
        this.perThreadImplementation.get().leaveCall(entryPoint);
    }

    @Override
    @Nullable
    public String findCallerForCurrentCallIfNotIntercepted(String callableName, InstrumentedGroovyCallsTracker.CallKind kind) {
        return this.perThreadImplementation.get().findCallerForCurrentCallIfNotIntercepted(callableName, kind);
    }

    @Override
    public void markCurrentCallAsIntercepted(String callableName, InstrumentedGroovyCallsTracker.CallKind kind) {
        this.perThreadImplementation.get().markCurrentCallAsIntercepted(callableName, kind);
    }
}

