/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class SnapshotWatchedDirectoryFinder {
    public static File getDirectoryToWatch(FileSystemLocationSnapshot snapshot) {
        File path = new File(snapshot.getAbsolutePath());
        switch (snapshot.getType()) {
            case RegularFile: {
                return path.getParentFile();
            }
            case Directory: {
                return path;
            }
            case Missing: {
                return SnapshotWatchedDirectoryFinder.findFirstExistingAncestor(path);
            }
        }
        throw new AssertionError();
    }

    private static File findFirstExistingAncestor(File path) {
        File candidate = path;
        do {
            if ((candidate = candidate.getParentFile()) != null) continue;
            throw new IllegalStateException("Couldn't find existing ancestor for " + path);
        } while (!candidate.isDirectory());
        return candidate;
    }
}

