/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.base.services;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.Build.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gradle/internal/cc/base/services/ProjectRefResolver;", "", "buildState", "Lorg/gradle/internal/build/BuildState;", "(Lorg/gradle/internal/build/BuildState;)V", "projectReadyLock", "Ljava/util/concurrent/CountDownLatch;", "projectsLoaded", "", "waitingForProjectsAllowed", "", "Ljava/lang/Thread;", "getProject", "Lorg/gradle/api/internal/project/ProjectInternal;", "path", "", "projectsReady", "", "waitForProjects", "projectPath", "withWaitingForProjectsAllowed", "block", "Lkotlin/Function0;", "configuration-cache-base"})
public final class ProjectRefResolver {
    @NotNull
    private final BuildState buildState;
    @NotNull
    private final CountDownLatch projectReadyLock;
    private volatile boolean projectsLoaded;
    @NotNull
    private final Set<Thread> waitingForProjectsAllowed;

    @Inject
    public ProjectRefResolver(@NotNull BuildState buildState) {
        Intrinsics.checkNotNullParameter((Object)buildState, (String)"buildState");
        this.buildState = buildState;
        this.projectReadyLock = new CountDownLatch(1);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        this.waitingForProjectsAllowed = keySetView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withWaitingForProjectsAllowed(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
        boolean wasFirstToAdd = this.waitingForProjectsAllowed.add(thread);
        try {
            block.invoke();
        }
        finally {
            if (wasFirstToAdd) {
                this.waitingForProjectsAllowed.remove(thread);
            }
        }
    }

    public final void projectsReady() {
        this.projectsLoaded = true;
        this.projectReadyLock.countDown();
    }

    @NotNull
    public final ProjectInternal getProject(@NotNull String path) throws InterruptedException, TimeoutException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.waitForProjects(path);
        ProjectInternal projectInternal = this.buildState.getProjects().getProject(Path.path((String)path)).getMutableModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectInternal, (String)"buildState.projects.getP\u2026.path(path)).mutableModel");
        return projectInternal;
    }

    private final void waitForProjects(String projectPath) {
        if (this.projectsLoaded) {
            return;
        }
        if (!this.waitingForProjectsAllowed.contains(Thread.currentThread())) {
            boolean bl = false;
            String string = "Cannot resolve project path '" + projectPath + "' because project structure is not yet loaded for build '" + this.buildState.getIdentityPath() + '\'';
            throw new IllegalStateException(string.toString());
        }
        if (!this.projectReadyLock.await(5L, TimeUnit.MINUTES)) {
            throw new TimeoutException("Cannot resolve project path '" + projectPath + "' because project structure is not ready in time for build '" + this.buildState.getIdentityPath() + '\'');
        }
    }
}

