/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.concurrent.Future;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.NodeExecutionAdvisor;
import org.junit.platform.engine.support.hierarchical.NodeTestTask;
import org.junit.platform.engine.support.hierarchical.NodeTestTaskContext;
import org.junit.platform.engine.support.hierarchical.NodeTreeWalker;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private final ExecutionRequest request;
    private final C rootContext;
    private final HierarchicalTestExecutorService executorService;
    private final ThrowableCollector.Factory throwableCollectorFactory;

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext, HierarchicalTestExecutorService executorService, ThrowableCollector.Factory throwableCollectorFactory) {
        this.request = request;
        this.rootContext = rootContext;
        this.executorService = executorService;
        this.throwableCollectorFactory = throwableCollectorFactory;
    }

    Future<Void> execute() {
        TestDescriptor rootTestDescriptor = this.request.getRootTestDescriptor();
        EngineExecutionListener executionListener = this.request.getEngineExecutionListener();
        NodeExecutionAdvisor executionAdvisor = new NodeTreeWalker().walk(rootTestDescriptor);
        NodeTestTaskContext taskContext = new NodeTestTaskContext(executionListener, this.executorService, this.throwableCollectorFactory, executionAdvisor);
        NodeTestTask<C> rootTestTask = new NodeTestTask<C>(taskContext, rootTestDescriptor);
        rootTestTask.setParentContext(this.rootContext);
        return this.executorService.submit(rootTestTask);
    }
}

