/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class FileNotationConverter
implements NotationConverter<Object, File> {
    private static final Pattern ENCODED_URI = Pattern.compile("%([0-9a-fA-F]{2})");

    public static NotationParser<Object, File> parser() {
        return NotationParserBuilder.toType(File.class).typeDisplayName("a File").noImplicitConverters().converter((NotationConverter)new FileNotationConverter()).toComposite();
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A String or CharSequence path").example("'src/main/java' or '/usr/include'");
        visitor.candidate("A String or CharSequence URI").example("'file:/usr/include'");
        visitor.candidate("A File instance.");
        visitor.candidate("A Path instance.");
        visitor.candidate("A Directory instance.");
        visitor.candidate("A RegularFile instance.");
        visitor.candidate("A URI or URL instance of file.");
        visitor.candidate("A TextResource instance.");
    }

    public void convert(Object notation, NotationConvertResult<? super File> result) throws TypeConversionException {
        if (notation instanceof File) {
            result.converted((Object)((File)notation));
            return;
        }
        if (notation instanceof Path) {
            result.converted((Object)((Path)notation).toFile());
            return;
        }
        if (notation instanceof FileSystemLocation) {
            result.converted((Object)((FileSystemLocation)notation).getAsFile());
            return;
        }
        if (notation instanceof URL) {
            try {
                notation = ((URL)notation).toURI();
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            if ("file".equals(uri.getScheme())) {
                try {
                    result.converted((Object)new File(uri));
                    return;
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidUserDataException(String.format("Cannot convert URI '%s' to a file.", uri), (Throwable)ex);
                }
            }
            return;
        }
        if (notation instanceof CharSequence) {
            String notationString = notation.toString();
            if (notationString.startsWith("file:")) {
                try {
                    URI uri = new URI(notationString);
                    try {
                        result.converted((Object)new File(uri));
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                result.converted((Object)new File(FileNotationConverter.fallbackUrlDecode(notationString)));
                return;
            }
            result.converted((Object)new File(notationString));
        }
        if (notation instanceof TextResource) {
            result.converted((Object)((TextResource)notation).asFile());
        }
    }

    private static String fallbackUrlDecode(String fullPath) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Passing invalid URIs to URI or File converting methods.").withAdvice("Use a valid URL or a file path instead of '" + fullPath + "'.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecated_invalid_url_decoding")).nagUser();
        String path = fullPath.substring(5);
        StringBuffer builder = new StringBuffer();
        Matcher matcher = ENCODED_URI.matcher(path);
        while (matcher.find()) {
            String val = matcher.group(1);
            matcher.appendReplacement(builder, String.valueOf((char)Integer.parseInt(val, 16)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }
}

