/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.scala.ScalaDocOptions;
import org.gradle.api.tasks.scala.internal.GenerateScaladoc;
import org.gradle.api.tasks.scala.internal.ScalaRuntimeHelper;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.internal.GUtil;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ScalaDoc
extends SourceTask {
    private File destinationDir;
    private FileCollection classpath;
    private FileCollection scalaClasspath;
    private ScalaDocOptions scalaDocOptions;
    private String title;
    private final Property<String> maxMemory;
    private final Property<JavaLauncher> javaLauncher;
    private final ConfigurableFileCollection compilationOutputs;

    public ScalaDoc() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.maxMemory = objectFactory.property(String.class);
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        this.javaLauncher = objectFactory.property(JavaLauncher.class).convention(javaToolchainService.launcherFor(it -> {}));
        this.compilationOutputs = objectFactory.fileCollection();
        this.scalaDocOptions = (ScalaDocOptions)((Object)objectFactory.newInstance(ScalaDocOptions.class, new Object[0]));
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @InputFiles
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    protected FileTree getFilteredCompilationOutputs() {
        return this.getCompilationOutputs().getAsFileTree().matching(this.getPatternSet()).matching(pattern -> pattern.include(new String[]{"**/*.tasty"}));
    }

    @Internal
    public ConfigurableFileCollection getCompilationOutputs() {
        return this.compilationOutputs;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getScalaClasspath() {
        return this.scalaClasspath;
    }

    public void setScalaClasspath(FileCollection scalaClasspath) {
        this.scalaClasspath = scalaClasspath;
    }

    @Nested
    public ScalaDocOptions getScalaDocOptions() {
        return this.scalaDocOptions;
    }

    @Deprecated
    public void setScalaDocOptions(ScalaDocOptions scalaDocOptions) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ScalaDoc.class, (String)"setScalaDocOptions(ScalaDocOptions)").replaceWith((Object)"scalaDocOptions(Action)")).withContext("Setting a new instance of scalaDocOptions is unnecessary.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_nested_properties_setters")).nagUser();
        this.scalaDocOptions = scalaDocOptions;
    }

    public void scalaDocOptions(Action<? super ScalaDocOptions> action) {
        action.execute((Object)this.getScalaDocOptions());
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Internal
    public Property<String> getMaxMemory() {
        return this.maxMemory;
    }

    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @TaskAction
    protected void generate() {
        ScalaDocOptions options = this.getScalaDocOptions();
        if (!GUtil.isTrue((Object)options.getDocTitle())) {
            options.setDocTitle(this.getTitle());
        }
        WorkQueue queue = this.getWorkerExecutor().processIsolation(worker -> {
            worker.getClasspath().from(new Object[]{this.getScalaClasspath()});
            JavaForkOptions forkOptions = worker.getForkOptions();
            if (this.getMaxMemory().isPresent()) {
                forkOptions.setMaxHeapSize((String)this.getMaxMemory().get());
            }
            forkOptions.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        });
        queue.submit(GenerateScaladoc.class, parameters -> {
            List<String> additionalParameters;
            String docTitle;
            File optionsFile = this.createOptionsFile();
            parameters.getOptionsFile().set(optionsFile);
            parameters.getClasspath().from(new Object[]{this.getClasspath()});
            parameters.getOutputDirectory().set(this.getDestinationDir());
            boolean isScala3 = ScalaRuntimeHelper.findScalaJar((Iterable<File>)this.getScalaClasspath(), "library_3") != null;
            parameters.getIsScala3().set((Object)isScala3);
            if (isScala3) {
                parameters.getSources().from(new Object[]{this.getFilteredCompilationOutputs()});
            } else {
                parameters.getSources().from(new Object[]{this.getSource()});
                if (options.isDeprecation()) {
                    parameters.getOptions().add((Object)"-deprecation");
                }
                if (options.isUnchecked()) {
                    parameters.getOptions().add((Object)"-unchecked");
                }
            }
            String footer = options.getFooter();
            if (footer != null) {
                parameters.getOptions().add((Object)"-doc-footer");
                parameters.getOptions().add((Object)footer);
            }
            if ((docTitle = options.getDocTitle()) != null) {
                parameters.getOptions().add((Object)"-doc-title");
                parameters.getOptions().add((Object)docTitle);
            }
            if ((additionalParameters = options.getAdditionalParameters()) != null) {
                parameters.getOptions().addAll(additionalParameters);
            }
        });
    }

    @Nullable
    private File createOptionsFile() {
        return new File(this.getTemporaryDir(), "scaladoc.options");
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    @Deprecated
    protected abstract IsolatedAntBuilder getAntBuilder();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();
}

