/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.CatchTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/TryTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtTryExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "translateAsBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "js.translator"})
public final class TryTranslator
extends AbstractTranslator {
    @NotNull
    private final KtTryExpression expression;

    public TryTranslator(@NotNull KtTryExpression expression2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.expression = expression2;
    }

    @NotNull
    public final KtTryExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public final JsTry translate() {
        JsBlock tryBlock = this.translateAsBlock(this.expression.getTryBlock());
        List<KtCatchClause> list = this.expression.getCatchClauses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCatchClauses(...)");
        PsiElement psiElement = this.expression;
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"context(...)");
        CatchTranslator catchTranslator = new CatchTranslator(list, psiElement, translationContext);
        JsCatch catchBlock = catchTranslator.translate();
        KtFinallySection ktFinallySection = this.expression.getFinallyBlock();
        KtBlockExpression finallyExpression = ktFinallySection != null ? ktFinallySection.getFinalExpression() : null;
        JsBlock finallyBlock = this.translateAsBlock(finallyExpression);
        return new JsTry(tryBlock, catchBlock, finallyBlock);
    }

    private final JsBlock translateAsBlock(KtExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        JsStatement jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(expression2, this.context());
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"translateAsStatementAndMergeInBlockIfNeeded(...)");
        JsStatement statement = jsStatement;
        return JsAstUtils.convertToBlock(statement);
    }
}

