/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeDescriberRegistry;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ArtifactSelectionException;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleArtifactFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class NoCompatibleArtifactFailureDescriber
extends AbstractResolutionFailureDescriber<NoCompatibleArtifactFailure> {
    private static final String NO_MATCHING_VARIANTS_PREFIX = "No matching variant errors are explained in more detail at ";
    private static final String NO_MATCHING_VARIANTS_SECTION = "sub:variant-no-match";
    private final AttributeDescriberRegistry attributeDescribers;

    @Inject
    public NoCompatibleArtifactFailureDescriber(AttributeDescriberRegistry attributeDescribers) {
        this.attributeDescribers = attributeDescribers;
    }

    public ArtifactSelectionException describeFailure(NoCompatibleArtifactFailure failure) {
        String message = this.buildFailureMsg(failure, this.attributeDescribers.getDescribers());
        List<String> resolutions = this.buildResolutions(this.suggestSpecificDocumentation(NO_MATCHING_VARIANTS_PREFIX, NO_MATCHING_VARIANTS_SECTION), this.suggestReviewAlgorithm());
        return new ArtifactSelectionException(message, failure, resolutions);
    }

    private String buildFailureMsg(NoCompatibleArtifactFailure failure, List<AttributeDescriber> attributeDescribers) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), attributeDescribers);
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.describeRequestTarget()) + " match the consumer attributes");
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : failure.getCandidates()) {
            formatter.node(assessedCandidate.getDisplayName());
            this.formatAttributeMatchesForIncompatibility(assessedCandidate, formatter, describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

