/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.MapEntrySnapshot;

class AbstractMapSnapshot<T extends Hashable>
implements Hashable {
    protected final ImmutableList<MapEntrySnapshot<T>> entries;

    public AbstractMapSnapshot(ImmutableList<MapEntrySnapshot<T>> entries) {
        this.entries = entries;
    }

    public ImmutableList<MapEntrySnapshot<T>> getEntries() {
        return this.entries;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)"Map");
        hasher.putInt(this.entries.size());
        for (MapEntrySnapshot entry : this.entries) {
            ((Hashable)entry.getKey()).appendToHasher(hasher);
            ((Hashable)entry.getValue()).appendToHasher(hasher);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMapSnapshot other = (AbstractMapSnapshot)obj;
        return this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return this.entries.toString();
    }
}

