/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import javax.annotation.Nullable;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.internal.GUtil;

public class UnsupportedNotationException
extends TypeConversionException {
    private final Object notation;
    private final Collection<String> candidates;

    public UnsupportedNotationException(Object notation) {
        super("Could not convert " + notation);
        this.notation = notation;
        this.candidates = Collections.emptyList();
    }

    public UnsupportedNotationException(Object notation, String failure, @Nullable String resolution, Collection<String> candidateTypes) {
        super(UnsupportedNotationException.format(failure, resolution, candidateTypes));
        this.notation = notation;
        this.candidates = candidateTypes;
    }

    public Collection<String> getCandidates() {
        return this.candidates;
    }

    private static String format(String failure, String resolution, Collection<String> formats) {
        Formatter message = new Formatter();
        message.format("%s%n", failure);
        message.format("The following types/formats are supported:", new Object[0]);
        for (String format : formats) {
            message.format("%n  - %s", format);
        }
        if (GUtil.isTrue(resolution)) {
            message.format("%n%n%s", resolution);
        }
        return message.toString();
    }

    public Object getNotation() {
        return this.notation;
    }
}

