/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.gradle.internal.UncheckedException;

public class JavaReflectionUtil {
    public static <T> T newInstance(Class<T> c) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static <T> TypeToken<?> extractNestedType(TypeToken<T> beanType, Class<? super T> parameterizedClass, int typeParameterIndex) {
        ParameterizedType type = (ParameterizedType)beanType.getSupertype(parameterizedClass).getType();
        return TypeToken.of((Type)type.getActualTypeArguments()[typeParameterIndex]);
    }

    public static boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return JavaReflectionUtil.getAnnotation(type, annotationType, true) != null;
    }

    @Nullable
    @VisibleForTesting
    static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return JavaReflectionUtil.getAnnotation(type, annotationType, true);
    }

    @Nullable
    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType, boolean checkType) {
        A annotation;
        if (checkType && (annotation = type.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        if (annotationType.getAnnotation(Inherited.class) != null) {
            for (Class<?> anInterface : type.getInterfaces()) {
                annotation = JavaReflectionUtil.getAnnotation(anInterface, annotationType, true);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if (type.isInterface() || type.equals(Object.class)) {
            return null;
        }
        return JavaReflectionUtil.getAnnotation(type.getSuperclass(), annotationType, false);
    }
}

