/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.AbstractZipEntry;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FileException;

public class FileZipInput
implements ZipInput {
    private final ZipFile file;
    private final Enumeration<? extends java.util.zip.ZipEntry> entries;

    public static ZipInput create(File file) throws FileException {
        if (FileZipInput.isZipFileSafeToUse()) {
            return new FileZipInput(file);
        }
        try {
            return new StreamZipInput(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new FileException(e);
        }
    }

    private static boolean isZipFileSafeToUse() {
        String versionString = System.getProperty("java.specification.version");
        String[] versionParts = versionString.split("\\.");
        if (versionParts.length < 1) {
            throw new IllegalArgumentException("Could not determine java version from '" + versionString + "'.");
        }
        return Integer.parseInt(versionParts[0]) >= 11;
    }

    private FileZipInput(File file) {
        try {
            this.file = new ZipFile(file);
        }
        catch (IOException e) {
            throw new FileException(e);
        }
        this.entries = this.file.entries();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new AbstractIterator<ZipEntry>(){

            protected ZipEntry computeNext() {
                if (!FileZipInput.this.entries.hasMoreElements()) {
                    return (ZipEntry)this.endOfData();
                }
                return new FileZipEntry((java.util.zip.ZipEntry)FileZipInput.this.entries.nextElement());
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    private class FileZipEntry
    extends AbstractZipEntry {
        public FileZipEntry(java.util.zip.ZipEntry entry) {
            super(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T withInputStream(ZipEntry.IoFunction<InputStream, T> action) throws IOException {
            InputStream inputStream = this.getInputStream();
            try {
                T t = action.apply(inputStream);
                return t;
            }
            finally {
                inputStream.close();
            }
        }

        private InputStream getInputStream() {
            try {
                return FileZipInput.this.file.getInputStream(this.getEntry());
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }

        @Override
        public boolean canReopen() {
            return true;
        }
    }
}

