/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator.main;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.declarative.dsl.evaluation.InterpretationSequence;
import org.gradle.declarative.dsl.evaluation.InterpretationSequenceStep;
import org.gradle.internal.declarativedsl.evaluator.defaults.ModelDefaultsDefinitionCollector;
import org.gradle.internal.declarativedsl.evaluator.features.ResolutionResultHandler;
import org.gradle.internal.declarativedsl.evaluator.main.AllSoftwareTypesApplyModelDefaultsHandler;
import org.gradle.internal.declarativedsl.evaluator.main.AnalysisSequenceResult;
import org.gradle.internal.declarativedsl.evaluator.main.ModelDefaultsStorage;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepContext;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepResult;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepRunner;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.evaluator.schema.DeclarativeScriptContext;
import org.gradle.internal.declarativedsl.evaluator.schema.InterpretationSchemaBuildingResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator;", "", "schemaBuilder", "Lkotlin/Function1;", "Lorg/gradle/internal/declarativedsl/evaluator/schema/DeclarativeScriptContext;", "Lorg/gradle/internal/declarativedsl/evaluator/schema/InterpretationSchemaBuildingResult;", "(Lkotlin/jvm/functions/Function1;)V", "analysisContext", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepContext;", "modelDefaultsStorage", "Lorg/gradle/internal/declarativedsl/evaluator/main/ModelDefaultsStorage;", "getSchemaBuilder", "()Lkotlin/jvm/functions/Function1;", "stepRunner", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepRunner;", "evaluate", "Lorg/gradle/internal/declarativedsl/evaluator/main/AnalysisSequenceResult;", "scriptFileName", "", "scriptSource", "scriptContextFromFileName", "fileName", "Companion", "declarative-dsl-evaluator"})
@SourceDebugExtension(value={"SMAP\nSimpleAnalysisEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAnalysisEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1279#2,2:103\n1293#2,4:105\n*S KotlinDebug\n*F\n+ 1 SimpleAnalysisEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator\n*L\n81#1:103,2\n81#1:105,4\n*E\n"})
public final class SimpleAnalysisEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<DeclarativeScriptContext, InterpretationSchemaBuildingResult> schemaBuilder;
    @NotNull
    private final AnalysisStepRunner stepRunner;
    @NotNull
    private final ModelDefaultsStorage modelDefaultsStorage;
    @NotNull
    private final AnalysisStepContext analysisContext;

    public SimpleAnalysisEvaluator(@NotNull Function1<? super DeclarativeScriptContext, ? extends InterpretationSchemaBuildingResult> schemaBuilder) {
        Intrinsics.checkNotNullParameter(schemaBuilder, (String)"schemaBuilder");
        this.schemaBuilder = schemaBuilder;
        this.stepRunner = new AnalysisStepRunner();
        this.modelDefaultsStorage = new ModelDefaultsStorage();
        Object[] objectArray = new ResolutionResultHandler[]{new ModelDefaultsDefinitionCollector(this.modelDefaultsStorage), new AllSoftwareTypesApplyModelDefaultsHandler(this.modelDefaultsStorage)};
        this.analysisContext = new AnalysisStepContext(CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final Function1<DeclarativeScriptContext, InterpretationSchemaBuildingResult> getSchemaBuilder() {
        return this.schemaBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisSequenceResult evaluate(@NotNull String scriptFileName, @NotNull String scriptSource) {
        AnalysisSequenceResult analysisSequenceResult;
        Intrinsics.checkNotNullParameter((Object)scriptFileName, (String)"scriptFileName");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        DeclarativeScriptContext scriptContext = this.scriptContextFromFileName(scriptFileName);
        InterpretationSchemaBuildingResult built = (InterpretationSchemaBuildingResult)this.schemaBuilder.invoke((Object)scriptContext);
        if (Intrinsics.areEqual((Object)built, (Object)InterpretationSchemaBuildingResult.SchemaNotBuilt.INSTANCE)) {
            analysisSequenceResult = new AnalysisSequenceResult(MapsKt.emptyMap());
        } else if (built instanceof InterpretationSchemaBuildingResult.InterpretationSequenceAvailable) {
            Iterable $this$associateWith$iv = ((InterpretationSchemaBuildingResult.InterpretationSequenceAvailable)built).getSequence().getSteps();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                InterpretationSequenceStep interpretationSequenceStep = (InterpretationSequenceStep)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                EvaluationResult<AnalysisStepResult> evaluationResult = this.stepRunner.runInterpretationSequenceStep(scriptFileName, scriptSource, (InterpretationSequenceStep)it, this.analysisContext);
                map.put(t, evaluationResult);
            }
            Map map = result$iv;
            analysisSequenceResult = new AnalysisSequenceResult(map);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return analysisSequenceResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final DeclarativeScriptContext scriptContextFromFileName(String fileName) {
        DeclarativeScriptContext declarativeScriptContext;
        String string = new File(fileName).getName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -2062421629: {
                    if (!string.equals("build.gradle.kts")) break;
                    n = 1;
                    break;
                }
                case -2062428890: {
                    if (!string.equals("build.gradle.dcl")) break;
                    n = 1;
                    break;
                }
                case -582367058: {
                    if (!string.equals("settings.gradle.kts")) break;
                    n = 2;
                    break;
                }
                case -582374319: {
                    if (!string.equals("settings.gradle.dcl")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    declarativeScriptContext = DeclarativeScriptContext.ProjectScript.INSTANCE;
                    return declarativeScriptContext;
                }
                case 2: {
                    declarativeScriptContext = DeclarativeScriptContext.SettingsScript.INSTANCE;
                    return declarativeScriptContext;
                }
            }
        }
        declarativeScriptContext = DeclarativeScriptContext.UnknownScript.INSTANCE;
        return declarativeScriptContext;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator$Companion;", "", "()V", "withSchema", "Lorg/gradle/internal/declarativedsl/evaluator/main/SimpleAnalysisEvaluator;", "settings", "Lorg/gradle/declarative/dsl/evaluation/InterpretationSequence;", "project", "declarative-dsl-evaluator"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleAnalysisEvaluator withSchema(@NotNull InterpretationSequence settings, @NotNull InterpretationSequence project) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new SimpleAnalysisEvaluator((Function1<? super DeclarativeScriptContext, ? extends InterpretationSchemaBuildingResult>)((Function1)new Function1<DeclarativeScriptContext, InterpretationSchemaBuildingResult>(project, settings){
                final /* synthetic */ InterpretationSequence $project;
                final /* synthetic */ InterpretationSequence $settings;
                {
                    this.$project = $project;
                    this.$settings = $settings;
                    super(1);
                }

                public final InterpretationSchemaBuildingResult invoke(DeclarativeScriptContext it) {
                    InterpretationSchemaBuildingResult interpretationSchemaBuildingResult;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DeclarativeScriptContext declarativeScriptContext = it;
                    if (Intrinsics.areEqual((Object)declarativeScriptContext, (Object)DeclarativeScriptContext.ProjectScript.INSTANCE)) {
                        interpretationSchemaBuildingResult = new InterpretationSchemaBuildingResult.InterpretationSequenceAvailable(this.$project);
                    } else if (Intrinsics.areEqual((Object)declarativeScriptContext, (Object)DeclarativeScriptContext.SettingsScript.INSTANCE)) {
                        interpretationSchemaBuildingResult = new InterpretationSchemaBuildingResult.InterpretationSequenceAvailable(this.$settings);
                    } else if (Intrinsics.areEqual((Object)declarativeScriptContext, (Object)DeclarativeScriptContext.UnknownScript.INSTANCE)) {
                        interpretationSchemaBuildingResult = InterpretationSchemaBuildingResult.SchemaNotBuilt.INSTANCE;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return interpretationSchemaBuildingResult;
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

