/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.universe.UniverseFactoryLoader;

@CommandDefinition(name="add-universe", description="Add a universe to the provisioning state. Called without a universe name, set the default universe of this installation")
public class StateAddUniverseCommand
extends AbstractStateCommand {
    @Option(completer=UniverseFactoryCompleter.class, required=true, description="Universe factory name")
    private String factory;
    @Option(required=false, description="Universe name")
    private String name;
    @Option(required=true, description="Universe location")
    private String location;

    public String getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.state.core.CoreStateAddUniverseCommand";
    }

    public static class UniverseFactoryCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(UniverseFactoryLoader.getInstance().getFactories());
            return names;
        }
    }
}

