/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.registry;

import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.CommandContainerBuilder;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;

public class AeshCommandRegistryBuilder<CI extends CommandInvocation> {
    private final MutableCommandRegistryImpl<CI> commandRegistry = new MutableCommandRegistryImpl();

    public static <T extends CommandInvocation> AeshCommandRegistryBuilder<T> builder() {
        return new AeshCommandRegistryBuilder();
    }

    private AeshCommandRegistryBuilder() {
    }

    public AeshCommandRegistryBuilder<CI> containerBuilder(CommandContainerBuilder<CI> builder) {
        this.commandRegistry.setCommandContainerBuilder(builder);
        return this;
    }

    public AeshCommandRegistryBuilder<CI> command(Class<? extends Command> command) throws CommandRegistryException {
        this.commandRegistry.addCommand(command);
        return this;
    }

    public AeshCommandRegistryBuilder<CI> commands(Class<? extends Command> ... commands) throws CommandRegistryException {
        for (Class<? extends Command> c : commands) {
            this.commandRegistry.addCommand(c);
        }
        return this;
    }

    public AeshCommandRegistryBuilder<CI> command(ProcessedCommand<Command<CI>, CI> processedCommand) {
        this.commandRegistry.addCommand(new AeshCommandContainer<CI>(processedCommand));
        return this;
    }

    public AeshCommandRegistryBuilder<CI> command(CommandContainer commandContainer) {
        this.commandRegistry.addCommand(commandContainer);
        return this;
    }

    public AeshCommandRegistryBuilder<CI> command(CommandLineParser<CI> parser) {
        this.commandRegistry.addCommand(new AeshCommandContainer<CI>(parser));
        return this;
    }

    public AeshCommandRegistryBuilder<CI> command(Command command) throws CommandRegistryException {
        this.commandRegistry.addCommand(command);
        return this;
    }

    public CommandRegistry<CI> create() {
        return this.commandRegistry;
    }
}

