/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Date;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SavedSearchJSONImpl
extends TwitterResponseImpl
implements SavedSearch {
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private int id;
    private static final long serialVersionUID = 3083819860391598212L;

    SavedSearchJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    SavedSearchJSONImpl(JSONObject savedSearch) throws TwitterException {
        this.init(savedSearch);
    }

    static ResponseList<SavedSearch> createSavedSearchList(HttpResponse res, Configuration conf) throws TwitterException {
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        JSONArray json = res.asJSONArray();
        try {
            ResponseListImpl<SavedSearch> savedSearches = new ResponseListImpl<SavedSearch>(json.length(), res);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject savedSearchesJSON = json.getJSONObject(i);
                SavedSearchJSONImpl savedSearch = new SavedSearchJSONImpl(savedSearchesJSON);
                savedSearches.add(savedSearch);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(savedSearch, savedSearchesJSON);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(savedSearches, json);
            }
            return savedSearches;
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(res.asString()).toString(), jsone);
        }
    }

    private void init(JSONObject savedSearch) throws TwitterException {
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", savedSearch, "EEE MMM dd HH:mm:ss z yyyy");
        this.query = z_T4JInternalParseUtil.getUnescapedString("query", savedSearch);
        this.position = z_T4JInternalParseUtil.getInt("position", savedSearch);
        this.name = z_T4JInternalParseUtil.getUnescapedString("name", savedSearch);
        this.id = z_T4JInternalParseUtil.getInt("id", savedSearch);
    }

    @Override
    public int compareTo(SavedSearch that) {
        return this.id - that.getId();
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedSearch)) {
            return false;
        }
        SavedSearch that = (SavedSearch)o;
        return this.id == that.getId();
    }

    public int hashCode() {
        int result = this.createdAt.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return new StringBuffer().append("SavedSearchJSONImpl{createdAt=").append(this.createdAt).append(", query='").append(this.query).append('\'').append(", position=").append(this.position).append(", name='").append(this.name).append('\'').append(", id=").append(this.id).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((SavedSearch)x0);
    }
}

