/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class UnitSeekAndDestroyMissionTest
extends FreeColTestCase {
    private static final UnitType veteranType = UnitSeekAndDestroyMissionTest.spec().getUnitType("model.unit.veteranSoldier");
    private LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testCapturedUnitsLoseMission() {
        ServerGame game = ServerTestHelper.startServerGame(UnitSeekAndDestroyMissionTest.getTestMap());
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer player1 = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile1 = map.getTile(2, 2);
        ServerUnit attacker = new ServerUnit(game, tile1, player1, veteranType);
        AIUnit aiUnit = aiMain.getAIUnit(attacker);
        UnitSeekAndDestroyMissionTest.assertNotNull((Object)aiUnit);
        ServerPlayer player2 = this.getServerPlayer(game, "model.nation.french");
        Tile tile2 = map.getTile(2, 1);
        Role soldierRole = UnitSeekAndDestroyMissionTest.spec().getRole("model.role.soldier");
        ServerUnit defender = new ServerUnit(game, tile2, player2, veteranType, soldierRole);
        player1.setStance(player2, Stance.WAR);
        player2.setStance(player1, Stance.WAR);
        UnitSeekAndDestroyMission mission = new UnitSeekAndDestroyMission(aiMain, aiUnit, defender);
        UnitSeekAndDestroyMissionTest.assertTrue((String)"Attacker should have a UnitSeekAndDestroyMission", (boolean)aiUnit.hasMission(UnitSeekAndDestroyMission.class));
        attacker.changeOwner(player2);
        UnitSeekAndDestroyMissionTest.assertEquals((String)"Attacking unit should have been captured", (Object)attacker.getOwner(), (Object)player2);
        aiUnit = aiMain.getAIUnit(attacker);
        UnitSeekAndDestroyMissionTest.assertNull((String)"Captured unit should lose previous mission", (Object)aiUnit.getMission());
    }

    public void testDoNotPursueUnitsInColonies() {
        ServerGame game = ServerTestHelper.startServerGame(UnitSeekAndDestroyMissionTest.getTestMap());
        Map map = game.getMap();
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        ServerPlayer player1 = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile1 = map.getTile(2, 2);
        ServerUnit attacker = new ServerUnit(game, tile1, player1, veteranType);
        AIUnit aiUnit = aiMain.getAIUnit(attacker);
        UnitSeekAndDestroyMissionTest.assertNotNull((Object)aiUnit);
        ServerPlayer player2 = this.getServerPlayer(game, "model.nation.french");
        Tile defenderTile = map.getTile(2, 1);
        Role soldierRole = UnitSeekAndDestroyMissionTest.spec().getRole("model.role.soldier");
        ServerUnit defender = new ServerUnit(game, defenderTile, player2, veteranType, soldierRole);
        player1.setStance(player2, Stance.WAR);
        player2.setStance(player1, Stance.WAR);
        UnitSeekAndDestroyMission mission = new UnitSeekAndDestroyMission(aiMain, aiUnit, defender);
        UnitSeekAndDestroyMissionTest.assertTrue((String)"Attacker should have a UnitSeekAndDestroyMission", (boolean)aiUnit.hasMission(UnitSeekAndDestroyMission.class));
        UnitSeekAndDestroyMissionTest.assertTrue((String)"UnitSeekAndDestroyMission should be valid", (boolean)aiUnit.getMission().isValid());
        this.getStandardColony(1, defenderTile.getX(), defenderTile.getY());
        UnitSeekAndDestroyMissionTest.assertFalse((String)"UnitSeekAndDestroyMission should NOT be valid anymore, defender in colony", (boolean)aiUnit.getMission().isValid());
    }
}

