/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class SetCurrentStopMessage
extends AttributeMessage {
    public static final String TAG = "setCurrentStop";
    private static final String INDEX_TAG = "index";
    private static final String UNIT_TAG = "unit";

    public SetCurrentStopMessage(Unit unit, int index) {
        super(TAG, UNIT_TAG, unit.getId(), INDEX_TAG, String.valueOf(index));
    }

    public SetCurrentStopMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, INDEX_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        int count;
        ServerUnit serverUnit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        String indexString = this.getStringAttribute(INDEX_TAG);
        try {
            serverUnit = serverPlayer.getOurFreeColGameObject(unitId, ServerUnit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        TradeRoute tr = serverUnit.getTradeRoute();
        if (tr == null) {
            return serverPlayer.clientError("Unit has no trade route: " + unitId);
        }
        try {
            count = Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfe) {
            return serverPlayer.clientError("Stop index is not an integer: " + indexString);
        }
        if (count < 0 || count >= tr.getStopCount()) {
            return serverPlayer.clientError("Invalid stop index: " + indexString);
        }
        return this.igc(freeColServer).setCurrentStop(serverPlayer, serverUnit, count);
    }
}

