/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class IndianDemandMessage
extends AttributeMessage {
    public static final String TAG = "indianDemand";
    private static final String AMOUNT_TAG = "amount";
    private static final String COLONY_TAG = "colony";
    private static final String RESULT_TAG = "result";
    private static final String TYPE_TAG = "type";
    private static final String UNIT_TAG = "unit";

    public IndianDemandMessage(Unit unit, Colony colony, GoodsType type, int amount) {
        super(TAG, UNIT_TAG, unit.getId(), COLONY_TAG, colony.getId(), TYPE_TAG, type == null ? null : type.getId(), AMOUNT_TAG, String.valueOf(amount));
    }

    public IndianDemandMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, COLONY_TAG, TYPE_TAG, AMOUNT_TAG, RESULT_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        Unit unit = this.getUnit(game);
        Colony colony = this.getColony(game);
        GoodsType type = this.getType(game);
        int amount = this.getAmount();
        Constants.IndianDemandAction initialResult = this.getResult();
        aiPlayer.indianDemandHandler(unit, colony, type, amount, initialResult);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = freeColClient.getMyPlayer();
        Unit unit = this.getUnit(game);
        Colony colony = this.getColony(game);
        GoodsType goodsType = this.getType(game);
        int amount = this.getAmount();
        if (unit == null) {
            logger.warning("IndianDemand with null unit.");
            return;
        }
        if (colony == null) {
            logger.warning("IndianDemand with null colony");
            return;
        }
        if (!player.owns(colony)) {
            throw new RuntimeException("Demand to anothers colony: " + colony);
        }
        this.igc(freeColClient).indianDemandHandler(unit, colony, goodsType, amount);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Colony colony;
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String colonyId = this.getStringAttribute(COLONY_TAG);
        Constants.IndianDemandAction result = this.getResult();
        try {
            if (serverPlayer.isIndian()) {
                unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
                if (unit.getMovesLeft() <= 0) {
                    return serverPlayer.clientError("Unit has no moves left: " + unitId);
                }
                colony = unit.getAdjacentSettlement(colonyId, Colony.class);
                if (result != Constants.IndianDemandAction.INDIAN_DEMAND_DONE) {
                    return serverPlayer.clientError("Result in demand: " + serverPlayer.getId() + " " + result);
                }
            } else {
                unit = game.getFreeColGameObject(unitId, Unit.class);
                if (unit == null) {
                    return serverPlayer.clientError("Not a unit: " + unitId);
                }
                colony = serverPlayer.getOurFreeColGameObject(colonyId, Colony.class);
                if (result == null) {
                    return serverPlayer.clientError("No result in demand response: " + serverPlayer.getId());
                }
            }
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        int amount = this.getAmount();
        if (amount <= 0) {
            return serverPlayer.clientError("Bad amount: " + amount);
        }
        return this.igc(freeColServer).indianDemand(serverPlayer, unit, colony, this.getType(game), amount, result);
    }

    public Unit getUnit(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    public Colony getColony(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(COLONY_TAG), Colony.class);
    }

    public GoodsType getType(Game game) {
        String typeId = this.getStringAttribute(TYPE_TAG);
        return typeId == null ? null : game.getSpecification().getGoodsType(typeId);
    }

    public int getAmount() {
        return this.getIntegerAttribute(AMOUNT_TAG, -1);
    }

    public Constants.IndianDemandAction getResult() {
        return this.getEnumAttribute(RESULT_TAG, Constants.IndianDemandAction.class, Constants.IndianDemandAction.INDIAN_DEMAND_DONE);
    }

    public IndianDemandMessage setResult(Constants.IndianDemandAction result) {
        this.setEnumAttribute(RESULT_TAG, result);
        return this;
    }
}

