/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class ChangeWorkTypeMessage
extends AttributeMessage {
    public static final String TAG = "changeWorkType";
    private static final String UNIT_TAG = "unit";
    private static final String WORK_TYPE_TAG = "workType";

    public ChangeWorkTypeMessage(Unit unit, GoodsType workType) {
        super(TAG, UNIT_TAG, unit.getId(), WORK_TYPE_TAG, workType.getId());
    }

    public ChangeWorkTypeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, WORK_TYPE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        Specification spec = freeColServer.getSpecification();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String workTypeId = this.getStringAttribute(WORK_TYPE_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasTile()) {
            return serverPlayer.clientError("Unit is not on the map: " + unitId);
        }
        GoodsType type = spec.getGoodsType(workTypeId);
        if (type == null) {
            return serverPlayer.clientError("Not a goods type: " + workTypeId);
        }
        return this.igc(freeColServer).changeWorkType(serverPlayer, unit, type);
    }
}

