/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Comparator;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.CollectionUtils;

public class NativeTradeItem
extends GoodsTradeItem {
    public static final String TAG = "nativeTradeItem";
    public static final Comparator<NativeTradeItem> descendingPriceComparator = Comparator.comparingInt(NativeTradeItem::getPrice).reversed().thenComparingInt(NativeTradeItem::getHaggleCount).thenComparing(nti -> nti.getGoods().getType(), GoodsType.goodsTypeComparator);
    public static final int PRICE_UNSET = 0;
    public static final int PRICE_INVALID = -1;
    private int price;
    private int haggleCount;
    private static final String HAGGLE_COUNT_TAG = "haggleCount";
    private static final String PRICE_TAG = "price";

    public NativeTradeItem(Game game, Player source, Player destination, Goods goods) {
        super(game, source, destination, goods);
        this.price = 0;
        this.haggleCount = 0;
    }

    public NativeTradeItem(NativeTradeItem nti) {
        super(nti.getGoods().getGame(), nti.getSource(), nti.getDestination(), nti.getGoods());
        this.price = nti.getPrice();
        this.haggleCount = nti.getHaggleCount();
    }

    public NativeTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    public boolean priceIsSet() {
        return this.price != 0;
    }

    public boolean priceIsValid() {
        return this.price > 0;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public int getHaggleCount() {
        return this.haggleCount;
    }

    public void setHaggleCount(int haggleCount) {
        this.haggleCount = haggleCount;
    }

    public Predicate<NativeTradeItem> goodsMatcher() {
        return CollectionUtils.matchKeyEquals(this.getGoods(), GoodsTradeItem::getGoods);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        NativeTradeItem o = this.copyInCast(other, NativeTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.price = o.getPrice();
        this.haggleCount = o.getHaggleCount();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PRICE_TAG, this.price);
        xw.writeAttribute(HAGGLE_COUNT_TAG, this.haggleCount);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.price = xr.getAttribute(PRICE_TAG, -1);
        this.haggleCount = xr.getAttribute(HAGGLE_COUNT_TAG, -1);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NativeTradeItem)) {
            return false;
        }
        NativeTradeItem other = (NativeTradeItem)o;
        return this.price == other.price && this.haggleCount == other.haggleCount && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + this.price;
        return 37 * hash + this.haggleCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.goods.getAmount()).append(' ').append(Messages.getName(this.goods)).append(' ').append(this.price).append(' ').append(this.haggleCount).append(']');
        return sb.toString();
    }
}

